import { jsx as _jsx } from "react/jsx-runtime";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { connectField } from "uniforms";
import wrapField from "./wrapField";
var ComponentType;
(function (ComponentType) {
    ComponentType["checkbox"] = "checkbox";
    ComponentType["switch"] = "switch";
})(ComponentType || (ComponentType = {}));
function BoolField({ appearance, disabled, id, inputRef, label, name, onChange, value, ...props }) {
    const Component = appearance === ComponentType.switch ? Switch : Checkbox;
    return wrapField({ id, ...props }, _jsx(Component, { "data-testid": "bool-field", isChecked: value !== null && value !== void 0 ? value : false, isDisabled: disabled, id: id, name: name, onChange: () => disabled || onChange(!value), ref: inputRef, label: label }));
}
BoolField.defaultProps = { appearance: ComponentType.checkbox };
export default connectField(BoolField);
//# sourceMappingURL=BoolField.js.map