"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Select_1 = require("@patternfly/react-core/dist/js/components/Select");
var wrapField_1 = __importDefault(require("./wrapField"));
function isSelectOptionObject(toBeDetermined) {
    return typeof toBeDetermined === "object" && !Array.isArray(toBeDetermined) && toBeDetermined !== null;
}
function SelectInputsField(props) {
    var _a = __read((0, react_1.useState)(false), 2), expanded = _a[0], setExpanded = _a[1];
    var _b = __read((0, react_1.useState)(function () {
        if (props.value === undefined) {
            return [];
        }
        if (props.value === null) {
            return "null";
        }
        if (Array.isArray(props.value)) {
            return __spreadArray([], __read(props.value), false);
        }
        return props.value;
    }), 2), selected = _b[0], setSelected = _b[1];
    var parseSelection = (0, react_1.useCallback)(function (selection, fieldType) {
        if (selection === null) {
            return "".concat(selection);
        }
        var parsedSelection = isSelectOptionObject(selection) ? selection.toString() : selection;
        if (fieldType !== Array) {
            return parsedSelection !== "" ? "".concat(parsedSelection) : "";
        }
        if (Array.isArray(selected)) {
            if (selected.includes("".concat(parsedSelection))) {
                return selected.filter(function (s) { return s !== "".concat(parsedSelection); });
            }
            return __spreadArray(["".concat(parsedSelection)], __read(selected), false);
        }
        return [];
    }, [selected]);
    var handleSelect = (0, react_1.useCallback)(function (event, selection) {
        if (selection === props.placeholder) {
            props.onChange(undefined);
            setSelected([]);
        }
        else {
            if (selection === "null") {
                props.onChange(null);
                setSelected("null");
            }
            else {
                var selectedItems = parseSelection(selection, props.fieldType);
                var onChanged = selection === null
                    ? null
                    : typeof selection === "number"
                        ? Array.isArray(selectedItems)
                            ? selectedItems.map(function (item) { return JSON.parse(item); })
                            : JSON.parse(selectedItems)
                        : selectedItems;
                props.onChange(onChanged);
                setSelected(selectedItems);
            }
        }
        setExpanded(false);
    }, [parseSelection, props]);
    var selectOptions = (0, react_1.useMemo)(function () {
        var _a;
        var options = [];
        if (props.placeholder) {
            options.push((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { isPlaceholder: true, value: props.placeholder }, "placeholder ".concat(props.allowedValues.length)));
        }
        (_a = props.allowedValues) === null || _a === void 0 ? void 0 : _a.forEach(function (value) {
            return options.push((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { value: value, children: props.transform ? props.transform(value) : "".concat(value) }, value));
        });
        return options;
    }, [props]);
    return (0, wrapField_1.default)(props, (0, jsx_runtime_1.jsx)("div", { "data-testid": "select-inputs-field", id: props.id, children: (0, jsx_runtime_1.jsx)(Select_1.Select, { isDisabled: props.disabled, id: props.id, variant: props.fieldType === Array ? Select_1.SelectVariant.typeaheadMulti : Select_1.SelectVariant.single, name: props.name, placeholderText: props.placeholder, isOpen: expanded, selections: selected, onToggle: function (isExpanded) { return setExpanded(isExpanded); }, onSelect: handleSelect, menuAppendTo: props.menuAppendTo, direction: props.direction, children: selectOptions }) }));
}
exports.default = SelectInputsField;
//# sourceMappingURL=SelectInputsField.js.map