"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var uniforms_1 = require("uniforms");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var wrapField_1 = __importDefault(require("./wrapField"));
var DateConstructor = (typeof global === "object" ? global : window).Date;
var dateFormat = function (value, type) {
    if (type === void 0) { type = "datetime-local"; }
    if (typeof value === "string") {
        return value === null || value === void 0 ? void 0 : value.slice(0, type === "datetime-local" ? -8 : -14);
    }
    return value === null || value === void 0 ? void 0 : value.toISOString().slice(0, type === "datetime-local" ? -8 : -14);
};
var dateParse = function (value, onChange) {
    var valueAsNumber = DateConstructor.parse(value);
    if (isNaN(valueAsNumber)) {
        var splitedValue = value.split("-");
        if (splitedValue.length > 1) {
            splitedValue[0] = parseInt(splitedValue[0]) > 9999 ? "9999" : splitedValue[0];
            onChange(new DateConstructor("".concat(splitedValue.join("-"), "Z")));
            return;
        }
        onChange(undefined);
    }
    else {
        var date = new DateConstructor("".concat(value, "Z"));
        if (date.getFullYear() < 10000) {
            onChange(date);
        }
        else {
            onChange(date);
        }
    }
};
function DateField(_a) {
    var _b;
    var onChange = _a.onChange, props = __rest(_a, ["onChange"]);
    var isInvalid = (0, react_1.useMemo)(function () {
        if (props.value === undefined) {
            return false;
        }
        if (props.min) {
            var minDate = new DateConstructor(props.min);
            if (minDate.toString() === "Invalid Date") {
                return false;
            }
            else if (props.value < minDate) {
                return "Should be after ".concat(minDate.toISOString());
            }
        }
        if (props.max) {
            var maxDate = new DateConstructor(props.max);
            if (maxDate.toString() === "Invalid Date") {
                return false;
            }
            else if (props.value > maxDate) {
                return "Should be before ".concat(maxDate.toISOString());
            }
        }
        return false;
    }, [props.value, props.min, props.max]);
    return (0, wrapField_1.default)(props, (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { id: props.id, "aria-label": "uniforms date field", "data-testid": "date-field", isDisabled: props.disabled, name: props.name, placeholder: props.placeholder, ref: props.inputRef, type: "datetime-local", onChange: function (value) {
                    props.disabled || dateParse(value, onChange);
                }, value: (_b = dateFormat(props.value, props.type)) !== null && _b !== void 0 ? _b : "" }), isInvalid && ((0, jsx_runtime_1.jsx)("div", { id: "".concat(props.id, "-invalid-date-time"), style: {
                    fontSize: "0.875rem",
                    color: "#c9190b",
                    marginTop: "0.25rem",
                }, children: isInvalid }))] }));
}
exports.default = (0, uniforms_1.connectField)(DateField);
//# sourceMappingURL=DateField.js.map