"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceDescriptorService = void 0;
var WorkspaceDescriptor_1 = require("../worker/api/WorkspaceDescriptor");
var uuid_1 = require("uuid");
var StorageService_1 = require("./StorageService");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var WorkspaceOrigin_1 = require("../worker/api/WorkspaceOrigin");
var GitConstants_1 = require("../constants/GitConstants");
var path_1 = require("path");
var FsService_1 = require("./FsService");
var WorkspacesBroadcastEvents_1 = require("../worker/api/WorkspacesBroadcastEvents");
var WorkspaceDescriptorService = (function () {
    function WorkspaceDescriptorService(descriptorFsService, storageService) {
        this.descriptorFsService = descriptorFsService;
        this.storageService = storageService;
    }
    WorkspaceDescriptorService.prototype.listAll = function (fs, schema) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceDescriptorsFilePaths;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.walk({
                            schema: schema,
                            baseAbsolutePath: this.getAbsolutePath(""),
                            shouldExcludeAbsolutePath: function () { return false; },
                            onVisit: function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var absolutePath = _b.absolutePath;
                                return __generator(this, function (_c) {
                                    return [2, absolutePath];
                                });
                            }); },
                        })];
                    case 1:
                        workspaceDescriptorsFilePaths = _a.sent();
                        return [2, Promise.all(workspaceDescriptorsFilePaths.map(function (p) { return __awaiter(_this, void 0, void 0, function () {
                                var content;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4, this.storageService.getFileContent(fs, p)];
                                        case 1:
                                            content = _a.sent();
                                            return [2, JSON.parse(EncoderDecoder_1.decoder.decode(content))];
                                    }
                                });
                            }); }))];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.bumpLastUpdatedDate = function (fs, workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { lastUpdatedDateISO: new Date().toISOString() }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.get = function (fs, workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceDescriptorFile, _a, _b, _c, _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0: return [4, this.storageService.getFile(fs, this.getAbsolutePath(workspaceId))];
                    case 1:
                        workspaceDescriptorFile = _e.sent();
                        if (!workspaceDescriptorFile) {
                            throw new Error("Workspace not found (".concat(workspaceId, ")"));
                        }
                        _b = (_a = JSON).parse;
                        _d = (_c = EncoderDecoder_1.decoder).decode;
                        return [4, workspaceDescriptorFile.getFileContents()];
                    case 2: return [2, _b.apply(_a, [_d.apply(_c, [_e.sent()])])];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.create = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspace;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        workspace = {
                            workspaceId: this.newWorkspaceId(),
                            name: ((_a = args.preferredName) === null || _a === void 0 ? void 0 : _a.trim()) || WorkspaceDescriptor_1.NEW_WORKSPACE_DEFAULT_NAME,
                            origin: args.origin,
                            createdDateISO: new Date().toISOString(),
                            lastUpdatedDateISO: new Date().toISOString(),
                            gitAuthSessionId: args.gitAuthSessionId,
                            gitInsecurelyDisableTlsCertificateValidation: args.gitInsecurelyDisableTlsCertificateValidation,
                        };
                        return [4, this.storageService.createOrOverwriteFile(args.fs, this.toStorageFile(workspace))];
                    case 1:
                        _b.sent();
                        return [2, workspace];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.delete = function (fs, workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.deleteFile(fs, this.getAbsolutePath(workspaceId))];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.rename = function (fs, workspaceId, newName) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { name: newName }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.turnIntoGist = function (fs, workspaceId, gistUrl, branch, insecurelyDisableTlsCertificateValidation) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { origin: {
                                        kind: WorkspaceOrigin_1.WorkspaceKind.GITHUB_GIST,
                                        url: gistUrl.toString(),
                                        branch: branch,
                                    }, gitInsecurelyDisableTlsCertificateValidation: insecurelyDisableTlsCertificateValidation }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        new FsService_1.Broadcaster().broadcast({
                            channel: workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WS_UPDATE_DESCRIPTOR" })];
                            }); }); },
                        });
                        new FsService_1.Broadcaster().broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WSS_UPDATE", workspaceId: workspaceId })];
                            }); }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.turnIntoSnippet = function (fs, workspaceId, snippetUrl, branch, insecurelyDisableTlsCertificateValidation) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { origin: {
                                        kind: WorkspaceOrigin_1.WorkspaceKind.BITBUCKET_SNIPPET,
                                        url: snippetUrl.toString(),
                                        branch: branch,
                                    }, gitInsecurelyDisableTlsCertificateValidation: insecurelyDisableTlsCertificateValidation }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        new FsService_1.Broadcaster().broadcast({
                            channel: workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WS_UPDATE_DESCRIPTOR" })];
                            }); }); },
                        });
                        new FsService_1.Broadcaster().broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WSS_UPDATE", workspaceId: workspaceId })];
                            }); }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.turnIntoGit = function (fs, workspaceId, url, branch, insecurelyDisableTlsCertificateValidation) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { origin: {
                                        kind: WorkspaceOrigin_1.WorkspaceKind.GIT,
                                        url: url.toString(),
                                        branch: branch !== null && branch !== void 0 ? branch : GitConstants_1.GIT_DEFAULT_BRANCH,
                                    }, gitInsecurelyDisableTlsCertificateValidation: insecurelyDisableTlsCertificateValidation }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        new FsService_1.Broadcaster().broadcast({
                            channel: workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WS_UPDATE_DESCRIPTOR" })];
                            }); }); },
                        });
                        new FsService_1.Broadcaster().broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WSS_UPDATE", workspaceId: workspaceId })];
                            }); }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.changeGitAuthSessionId = function (fs, workspaceId, gitAuthSessionId, insecurelyDisableTlsCertificateValidation) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { gitAuthSessionId: gitAuthSessionId, gitInsecurelyDisableTlsCertificateValidation: insecurelyDisableTlsCertificateValidation }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        new FsService_1.Broadcaster().broadcast({
                            channel: workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WS_UPDATE_DESCRIPTOR" })];
                            }); }); },
                        });
                        new FsService_1.Broadcaster().broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WSS_UPDATE", workspaceId: workspaceId })];
                            }); }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.turnIntoLocal = function (fs, workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            var file, _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.toStorageFile;
                        _b = [{}];
                        return [4, this.get(fs, workspaceId)];
                    case 1:
                        file = _a.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.sent())])), { origin: {
                                        kind: WorkspaceOrigin_1.WorkspaceKind.LOCAL,
                                        branch: GitConstants_1.GIT_DEFAULT_BRANCH,
                                    } }])]);
                        return [4, this.storageService.updateFile(fs, file.path, file.getFileContents)];
                    case 2:
                        _c.sent();
                        new FsService_1.Broadcaster().broadcast({
                            channel: workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WS_UPDATE_DESCRIPTOR" })];
                            }); }); },
                        });
                        new FsService_1.Broadcaster().broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                return [2, ({ type: "WSS_UPDATE", workspaceId: workspaceId })];
                            }); }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceDescriptorService.prototype.getAbsolutePath = function (relativePath) {
        return (0, path_1.join)("/", this.descriptorFsService.getMountPoint(), relativePath !== null && relativePath !== void 0 ? relativePath : "");
    };
    WorkspaceDescriptorService.prototype.toStorageFile = function (descriptor) {
        return new StorageService_1.StorageFile({
            path: this.getAbsolutePath(descriptor.workspaceId),
            getFileContents: function () { return Promise.resolve(EncoderDecoder_1.encoder.encode(JSON.stringify(descriptor))); },
        });
    };
    WorkspaceDescriptorService.prototype.newWorkspaceId = function () {
        return (0, uuid_1.v4)();
    };
    return WorkspaceDescriptorService;
}());
exports.WorkspaceDescriptorService = WorkspaceDescriptorService;
//# sourceMappingURL=WorkspaceDescriptorService.js.map