"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FsCache = void 0;
exports.fsSchemaDir = fsSchemaDir;
var path_1 = require("path");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var MAX_NUMBER_OF_CACHED_FS_INSTANCES = 3;
var FsCache = (function () {
    function FsCache() {
        this.schemasCache = {};
        this.cache = new Map();
    }
    FsCache.prototype.hasSpaceFor = function (fsMountPoint) {
        return this.cache.has(fsMountPoint) || this.cache.size < MAX_NUMBER_OF_CACHED_FS_INSTANCES;
    };
    FsCache.prototype.getLastRecentlyUsed = function () {
        var _a = __read(__spreadArray([], __read(this.cache.entries()), false).sort(function (_a, _b) {
            var _c = __read(_a, 2), _ = _c[0], a = _c[1];
            var _d = __read(_b, 2), __ = _d[0], b = _d[1];
            return a.lastHit.valueOf() - b.lastHit.valueOf();
        })[0], 2), lruFsMountPoint = _a[0], _ = _a[1];
        return lruFsMountPoint;
    };
    FsCache.prototype.getOrLoadFsSchema = function (fsMountPoint) {
        var schema = this.schemasCache[fsMountPoint];
        if (schema) {
            return schema;
        }
        var newFsSchemaPromise = this.loadFsSchema(fsMountPoint);
        this.schemasCache[fsMountPoint] = newFsSchemaPromise;
        return newFsSchemaPromise;
    };
    FsCache.prototype.getOrLoadFs = function (fsMountPoint) {
        var hit = this.cache.get(fsMountPoint);
        if (hit) {
            this.cache.set(fsMountPoint, { fs: hit.fs, lastHit: new Date() });
            return hit.fs;
        }
        var newFsPromise = this.loadFs(fsMountPoint);
        this.cache.set(fsMountPoint, { fs: newFsPromise, lastHit: new Date() });
        return newFsPromise;
    };
    FsCache.prototype.loadFsSchema = function (fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            var fsSchemaIndexJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.debug("Loading FS Schema for ".concat(fsMountPoint));
                        console.time("Load FS Schema for ".concat(fsMountPoint));
                        this.createFsSchemaStructure(fsMountPoint);
                        return [4, this.syncFsSchema(true, fsMountPoint)];
                    case 1:
                        _a.sent();
                        try {
                            fsSchemaIndexJson = FS.readFile(fsSchemaJsonPath(fsMountPoint), toReadWriteFileOptions({ encoding: "utf8" }));
                            return [2, new Map(JSON.parse(fsSchemaIndexJson))];
                        }
                        catch (e) {
                            try {
                                throwWasiErrorToNodeError("Reading FS Schema JSON", e);
                            }
                            catch (err) {
                                if (err.code === "ENOENT") {
                                    return [2, new Map()];
                                }
                                else {
                                    throw err;
                                }
                            }
                        }
                        finally {
                            console.timeEnd("Load FS Schema for ".concat(fsMountPoint));
                        }
                        return [2];
                }
            });
        });
    };
    FsCache.prototype.syncFsSchema = function (isRestore, fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, new Promise(function (res) {
                        try {
                            IDBFS.syncfs({ mountpoint: fsSchemaDir(fsMountPoint) }, isRestore, res);
                        }
                        catch (e) {
                            try {
                                throwWasiErrorToNodeError("Sync FS Schema '".concat(fsMountPoint, "' (").concat(isRestore, ")"), e);
                            }
                            catch (err) {
                                console.error(err);
                                throw err;
                            }
                        }
                    })];
            });
        });
    };
    FsCache.prototype.createFsSchemaStructure = function (fsMountPoint) {
        try {
            FS.stat(fsSchemaDir(fsMountPoint));
            console.debug("FS Schema already loaded for ".concat(fsMountPoint));
        }
        catch (e) {
            FS.mkdir(fsSchemaDir(fsMountPoint));
            FS.mount(IDBFS, {}, fsSchemaDir(fsMountPoint));
        }
    };
    FsCache.prototype.flushFsSchema = function (fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            var fsSchemaToFlush, _a, _b, _c, _d, _e, _f;
            return __generator(this, function (_g) {
                switch (_g.label) {
                    case 0:
                        _b = (_a = EncoderDecoder_1.encoder).encode;
                        _d = (_c = JSON).stringify;
                        _f = (_e = Array).from;
                        return [4, this.getOrLoadFsSchema(fsMountPoint)];
                    case 1:
                        fsSchemaToFlush = _b.apply(_a, [_d.apply(_c, [_f.apply(_e, [(_g.sent()).entries()])])]);
                        try {
                            FS.writeFile(fsSchemaJsonPath(fsMountPoint), fsSchemaToFlush, toReadWriteFileOptions({ encoding: "utf8" }));
                        }
                        catch (e) {
                            throwWasiErrorToNodeError("Writing FS Schema JSON", e);
                        }
                        return [4, this.syncFsSchema(false, fsMountPoint)];
                    case 2:
                        _g.sent();
                        return [2];
                }
            });
        });
    };
    FsCache.prototype.loadFs = function (fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            var newFs;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        newFs = {
                            promises: {
                                rename: function (path, newPath) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_1;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 3, , 4]);
                                                FS.rename(path, newPath);
                                                return [4, this.getOrLoadFsSchema(fsMountPoint)];
                                            case 1:
                                                (_a.sent()).delete(path);
                                                return [4, newFs.promises.lstat(newPath)];
                                            case 2:
                                                _a.sent();
                                                return [3, 4];
                                            case 3:
                                                e_1 = _a.sent();
                                                throwWasiErrorToNodeError("rename", e_1, path, newPath);
                                                return [3, 4];
                                            case 4: return [2];
                                        }
                                    });
                                }); },
                                readFile: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        try {
                                            return [2, FS.readFile(path, toReadWriteFileOptions(options))];
                                        }
                                        catch (e) {
                                            throwWasiErrorToNodeError("readFile", e, path, options);
                                        }
                                        return [2];
                                    });
                                }); },
                                writeFile: function (path, data, options) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_2;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.writeFile(path, data, toReadWriteFileOptions(options));
                                                return [4, newFs.promises.lstat(path)];
                                            case 1:
                                                _a.sent();
                                                return [3, 3];
                                            case 2:
                                                e_2 = _a.sent();
                                                throwWasiErrorToNodeError("writeFile", e_2, path, data, options);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                unlink: function (path) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_3;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.unlink(path);
                                                return [4, this.getOrLoadFsSchema(fsMountPoint)];
                                            case 1:
                                                (_a.sent()).delete(path);
                                                return [3, 3];
                                            case 2:
                                                e_3 = _a.sent();
                                                throwWasiErrorToNodeError("unlink", e_3, path);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                readdir: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        try {
                                            return [2, removeDotPaths(FS.readdir(path, options))];
                                        }
                                        catch (e) {
                                            throwWasiErrorToNodeError("readdir", e, path, options);
                                        }
                                        return [2];
                                    });
                                }); },
                                mkdir: function (path, mode) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_4;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.mkdir(path, mode);
                                                return [4, newFs.promises.lstat(path)];
                                            case 1:
                                                _a.sent();
                                                return [3, 3];
                                            case 2:
                                                e_4 = _a.sent();
                                                throwWasiErrorToNodeError("mkdir", e_4, path, mode);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                rmdir: function (path) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_5;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.rmdir(path);
                                                return [4, this.getOrLoadFsSchema(fsMountPoint)];
                                            case 1:
                                                (_a.sent()).delete(path);
                                                return [3, 3];
                                            case 2:
                                                e_5 = _a.sent();
                                                throwWasiErrorToNodeError("rmdir", e_5, path);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                stat: function (path) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_6;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                return [4, toLfsStat(this, fsMountPoint, path, FS.stat(path))];
                                            case 1: return [2, _a.sent()];
                                            case 2:
                                                e_6 = _a.sent();
                                                throwWasiErrorToNodeError("stat", e_6, path);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                lstat: function (path) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_7;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                return [4, toLfsStat(this, fsMountPoint, path, FS.stat(path))];
                                            case 1: return [2, _a.sent()];
                                            case 2:
                                                e_7 = _a.sent();
                                                throwWasiErrorToNodeError("lstat", e_7, path);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                readlink: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        try {
                                            return [2, FS.readlink(path)];
                                        }
                                        catch (e) {
                                            throwWasiErrorToNodeError("readlink", e, path, options);
                                        }
                                        return [2];
                                    });
                                }); },
                                symlink: function (target, path, type) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_8;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.symlink(target, path);
                                                return [4, newFs.promises.lstat(path)];
                                            case 1:
                                                _a.sent();
                                                return [3, 3];
                                            case 2:
                                                e_8 = _a.sent();
                                                throwWasiErrorToNodeError("symlink", e_8, target, path, type);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                                chmod: function (path, mode) { return __awaiter(_this, void 0, void 0, function () {
                                    var e_9;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 2, , 3]);
                                                FS.chmod(path, mode);
                                                return [4, newFs.promises.lstat(path)];
                                            case 1:
                                                _a.sent();
                                                return [3, 3];
                                            case 2:
                                                e_9 = _a.sent();
                                                throwWasiErrorToNodeError("chmod", e_9, path, mode);
                                                return [3, 3];
                                            case 3: return [2];
                                        }
                                    });
                                }); },
                            },
                        };
                        console.time("Load FS to memory - ".concat(fsMountPoint));
                        console.debug("Loading FS to memory - ".concat(fsMountPoint));
                        return [4, this.createFsStructure(fsMountPoint)];
                    case 1:
                        _a.sent();
                        return [4, this.syncFs(true, fsMountPoint)];
                    case 2:
                        _a.sent();
                        return [4, this.getOrLoadFsSchema(fsMountPoint)];
                    case 3:
                        _a.sent();
                        console.timeEnd("Load FS to memory - ".concat(fsMountPoint));
                        return [2, newFs];
                }
            });
        });
    };
    FsCache.prototype.syncFs = function (isRestore, fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, new Promise(function (res) {
                            try {
                                IDBFS.syncfs({ mountpoint: fsMountPoint }, isRestore, res);
                            }
                            catch (e) {
                                try {
                                    throwWasiErrorToNodeError("Sync FS '".concat(fsMountPoint, "' (").concat(isRestore, ")"), e);
                                }
                                catch (err) {
                                    console.error(err);
                                    throw err;
                                }
                            }
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    FsCache.prototype.createFsStructure = function (fsMountPoint) {
        console.time("Load FS - ".concat(fsMountPoint));
        console.debug("Loading FS - ".concat(fsMountPoint));
        try {
            FS.mkdir(fsMountPoint);
            FS.mount(IDBFS, {}, fsMountPoint);
            this.createFsSchemaStructure(fsMountPoint);
        }
        catch (e) {
            try {
                throwWasiErrorToNodeError("Load FS ".concat(fsMountPoint), e, fsMountPoint);
            }
            catch (err) {
                console.error("Error loading FS - ".concat(fsMountPoint));
                console.error(err);
            }
        }
        finally {
            console.timeEnd("Load FS - ".concat(fsMountPoint));
        }
    };
    FsCache.prototype.unloadFs = function (fsMountPoint) {
        console.debug("Unloading FS - ".concat(fsMountPoint));
        console.time("Unload FS - ".concat(fsMountPoint));
        this.cache.delete(fsMountPoint);
        try {
            FS.unmount(fsMountPoint);
            FS.rmdir(fsMountPoint);
        }
        catch (e) {
            try {
                throwWasiErrorToNodeError("Unload FS ".concat(fsMountPoint), e, fsMountPoint);
            }
            catch (err) {
                console.error("Error unloading FS - ".concat(fsMountPoint));
                console.error(err);
            }
        }
        finally {
            console.timeEnd("Unload FS - ".concat(fsMountPoint));
        }
    };
    FsCache.prototype.flushFs = function (fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.time("Flush FS - ".concat(fsMountPoint));
                        console.debug("Flushing FS - ".concat(fsMountPoint));
                        return [4, this.syncFs(false, fsMountPoint)];
                    case 1:
                        _a.sent();
                        return [4, this.flushFsSchema(fsMountPoint)];
                    case 2:
                        _a.sent();
                        console.timeEnd("Flush FS - ".concat(fsMountPoint));
                        return [2];
                }
            });
        });
    };
    return FsCache;
}());
exports.FsCache = FsCache;
function fsSchemaDir(fsMountPoint) {
    return "".concat(fsMountPoint, "_schema");
}
function fsSchemaJsonPath(fsMountPoint) {
    return (0, path_1.join)(fsSchemaDir(fsMountPoint), "schema.json");
}
function toReadWriteFileOptions(options) {
    return typeof options === "string" ? { encoding: options } : options;
}
function removeDotPaths(paths) {
    return paths.slice(2);
}
function toLfsStat(fsCache, fsMountPoint, path, stat) {
    return __awaiter(this, void 0, void 0, function () {
        var schema, perpetualStat, isDir, isFile, isLink;
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4, fsCache.getOrLoadFsSchema(fsMountPoint)];
                case 1:
                    schema = _b.sent();
                    perpetualStat = schema.set(path, (_a = schema.get(path)) !== null && _a !== void 0 ? _a : { ino: stat.ino, mode: stat.mode }).get(path);
                    isDir = FS.isDir(perpetualStat.mode);
                    isFile = FS.isFile(perpetualStat.mode);
                    isLink = FS.isLink(perpetualStat.mode);
                    return [2, {
                            mode: perpetualStat.mode,
                            size: stat.size,
                            ino: perpetualStat.ino,
                            mtimeMs: stat.mtime,
                            ctimeMs: stat.ctime,
                            uid: 1,
                            gid: 1,
                            dev: 1,
                            isDirectory: function () { return isDir; },
                            isFile: function () { return isFile; },
                            isSymbolicLink: function () { return isLink; },
                        }];
            }
        });
    });
}
function throwWasiErrorToNodeError(id, e) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    switch (e.errno) {
        case 20:
            throw { id: id, code: "EEXIST", message: "EEXIST", args: args };
        case 44:
            throw { id: id, code: "ENOENT", message: "ENOENT", args: args };
        case 54:
            throw { id: id, code: "ENOTDIR", message: "ENOTDIR", args: args };
        case 55:
            throw { id: id, code: "ENOTEMPTY", message: "ENOTEMPTY", args: args };
        case 73:
            throw { id: id, code: "ETIMEDOUT", message: "ETIMEDOUT", args: args };
        default:
            throw { id: id, e: e, code: "UNKNOWN", args: args };
    }
}
//# sourceMappingURL=FsCache.js.map