import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import FormsListToolbar from "../FormsListToolbar/FormsListToolbar";
import FormsTable from "../FormsTable/FormsTable";
import FormsGallery from "../FormsGallery/FormsGallery";
import { BarsIcon, ThIcon } from "@patternfly/react-icons/dist/js/icons";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { ToggleGroup, ToggleGroupItem, } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
const FormsList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [filterFormNames, setFilterFormNames] = useState([]);
    const [formsData, setFormsData] = useState([]);
    const [isSelected, setIsSelected] = useState({
        tableView: true,
        cardsView: false,
    });
    const [isLoading, setIsLoading] = useState(true);
    const [error, setError] = useState(null);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
    }, [isEnvelopeConnectedToChannel]);
    const init = async () => {
        try {
            const namesFilter = await driver.getFormFilter();
            setFilterFormNames(namesFilter.formNames);
            setIsLoading(true);
            const response = await driver.getFormsQuery();
            setFormsData(response);
            setIsLoading(false);
        }
        catch (errorResponse) {
            setError(errorResponse);
        }
    };
    const applyFilter = (filters) => {
        driver.applyFilter(filters);
        init();
    };
    const handleItemClick = (_isChosen, event) => {
        const toggleButtonId = event.currentTarget.id;
        if (toggleButtonId === "tableView") {
            setIsSelected({
                tableView: true,
                cardsView: false,
            });
        }
        else if (toggleButtonId === "cardsView") {
            setIsSelected({
                tableView: false,
                cardsView: true,
            });
        }
    };
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "forms-list", ouiaSafe), children: [_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormsListToolbar, { applyFilter: applyFilter, setFilterFormNames: setFilterFormNames, filterFormNames: filterFormNames }) }), _jsx(SplitItem, { isFilled: true }), _jsx(SplitItem, { style: { padding: "20px" }, children: _jsxs(ToggleGroup, { "aria-label": "switch view toggle group", children: [_jsx(ToggleGroupItem, { icon: _jsx(BarsIcon, {}), "aria-label": "table view icon button", buttonId: "tableView", isSelected: isSelected.tableView, onChange: handleItemClick }), _jsx(ToggleGroupItem, { icon: _jsx(ThIcon, {}), "aria-label": "card view icon button", buttonId: "cardsView", isSelected: isSelected.cardsView, onChange: handleItemClick })] }) })] }), _jsx(Divider, {}), isSelected.tableView ? (_jsx(FormsTable, { driver: driver, formsData: formsData, setFormsData: setFormsData, isLoading: isLoading })) : (_jsx(FormsGallery, { formsData: formsData, driver: driver, isLoading: isLoading }))] }));
};
export default FormsList;
//# sourceMappingURL=FormsList.js.map