import { jsx as _jsx } from "react/jsx-runtime";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, } from "../../api";
import { BeeTable } from "../../table/BeeTable";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { useCallback, useMemo } from "react";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { FILTER_EXPRESSION_EXTRA_WIDTH, FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH, FILTER_EXPRESSION_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { FilterExpressionCollectionCell } from "./FilterExpressionCollectionCell";
import { FilterExpressionMatchCell } from "./FilterExpressionMatchCell";
import "./FilterExpression.css";
export function FilterExpressionComponent({ isNested, parentElementId, expression: filterExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = filterExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = filterExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                minWidth: FILTER_EXPRESSION_MIN_WIDTH,
                width: undefined,
            },
        ];
    }, [filterExpression, expressionHolderId]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
            {
                group: i18n.function.toUpperCase(),
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
        ];
    }, [i18n]);
    const tableRows = useMemo(() => {
        return [filterExpression.in];
    }, [filterExpression.in]);
    const allowedOperations = useCallback((conditions) => {
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        return [
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.columnIndex > 1
                ? [BeeTableOperation.SelectionCut, BeeTableOperation.SelectionPaste, BeeTableOperation.SelectionReset]
                : []),
        ];
    }, []);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        var _a, _b;
        return {
            nestedExpressions: [filterExpression.in.expression, filterExpression.match.expression],
            fixedColumnActualWidth: 0,
            fixedColumnResizingWidth: { value: 0, isPivoting: false },
            fixedColumnMinWidth: 0,
            nestedExpressionMinWidth: FILTER_EXPRESSION_MIN_WIDTH,
            extraWidth: FILTER_EXPRESSION_EXTRA_WIDTH,
            expression: filterExpression,
            flexibleColumnIndex: 1,
            widthsById: widthsById,
            nestedExpressionsExtraWidths: new Map([
                [(_b = (_a = filterExpression.match.expression) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : "", FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH],
            ]),
        };
    }, [filterExpression, widthsById]));
    const cellComponentByColumnAccessor = useMemo(() => ({
        [expressionHolderId]: (props) => _jsx(FilterExpressionCollectionCell, { ...props, parentElementId: parentElementId }),
    }), [expressionHolderId, parentElementId]);
    const beeTableAdditionalRow = useMemo(() => {
        return [
            _jsx(FilterExpressionMatchCell, { rowIndex: 1, columnIndex: 1, parentElementId: parentElementId, data: [filterExpression.match], columnId: "filterExpressionColumn" }, "filter-expression-match-cell"),
        ];
    }, [filterExpression.match, parentElementId]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        var _a, _b;
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: expressionHolderId,
            typeChange: typeRef !== filterExpression["@_typeRef"]
                ? {
                    from: (_a = filterExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "",
                    to: typeRef,
                }
                : undefined,
            nameChange: name !== filterExpression["@_label"]
                ? {
                    from: (_b = filterExpression["@_label"]) !== null && _b !== void 0 ? _b : "",
                    to: name,
                }
                : undefined,
        };
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_label": name,
                    "@_typeRef": typeRef,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [expressionHolderId, filterExpression, setExpression]);
    return (_jsx(NestedExpressionContainerContext.Provider, { value: nestedExpressionContainerValue, children: _jsx(BeeTable, { isReadOnly: isReadOnly, isEditableHeader: !isReadOnly, onColumnResizingWidthChange: onColumnResizingWidthChange, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: filterExpression["@_id"], headerVisibility: headerVisibility, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: beeTableColumns, rows: tableRows, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false, additionalRow: beeTableAdditionalRow }) }));
}
//# sourceMappingURL=FilterExpressionComponent.js.map