import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { generateUuid } from "../../api";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import { solveResultAndEntriesIndex } from "./ContextExpression";
export function ContextResultExpressionCell(props) {
    var _a, _b;
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { resultIndex } = solveResultAndEntriesIndex({
        contextEntries: (_a = props.contextExpression.contextEntry) !== null && _a !== void 0 ? _a : [],
        rowIndex: props.rowIndex,
    });
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b;
                const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
                const newExpression = getNewExpression((_b = newContextEntries[resultIndex]) === null || _b === void 0 ? void 0 : _b.expression);
                if (resultIndex <= -1) {
                    newContextEntries.push({
                        "@_id": generateUuid(),
                        expression: newExpression,
                    });
                }
                else if (newExpression) {
                    newContextEntries.splice(resultIndex, 1, {
                        ...newContextEntries[resultIndex],
                        expression: newExpression,
                    });
                }
                else {
                    newContextEntries.splice(resultIndex, 1);
                }
                const ret = {
                    ...prev,
                    contextEntry: newContextEntries,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [resultIndex, setExpression]);
    const resultEntry = resultIndex <= -1 ? undefined : (_b = props.contextExpression.contextEntry) === null || _b === void 0 ? void 0 : _b[resultIndex];
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: resultEntry === null || resultEntry === void 0 ? void 0 : resultEntry.expression, isResetSupported: true, isNested: true, rowIndex: resultIndex, columnIndex: props.columnIndex, parentElementId: props.contextExpression["@_id"], parentElementTypeRef: props.contextExpression["@_typeRef"], parentElementName: props.contextExpression["@_label"] }) }));
}
//# sourceMappingURL=ContextResultExpressionCell.js.map