import { jsx as _jsx } from "react/jsx-runtime";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, } from "../../api";
import { BeeTable } from "../../table/BeeTable";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { useCallback, useMemo } from "react";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { BeeTableReadOnlyCell } from "../../table/BeeTable/BeeTableReadOnlyCell";
import { ConditionalExpressionCell } from "./ConditionalExpressionCell";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, CONDITIONAL_EXPRESSION_EXTRA_WIDTH, CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH, } from "../../resizing/WidthConstants";
export function ConditionalExpression({ isNested, parentElementId, expression: conditionalExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const tableRows = useMemo(() => {
        return [
            { label: "if", part: conditionalExpression.if },
            { label: "then", part: conditionalExpression.then },
            { label: "else", part: conditionalExpression.else },
        ];
    }, [conditionalExpression.else, conditionalExpression.if, conditionalExpression.then]);
    const cellComponentByColumnAccessor = useMemo(() => {
        return {
            label: (props) => {
                return _jsx(BeeTableReadOnlyCell, { value: props.data[props.rowIndex].label });
            },
            part: (props) => {
                return _jsx(ConditionalExpressionCell, { ...props, parentElementId: parentElementId });
            },
        };
    }, [parentElementId]);
    const id = conditionalExpression["@_id"];
    const tableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = conditionalExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                isRowIndexColumn: false,
                dataType: (_b = conditionalExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                width: undefined,
                columns: [
                    {
                        accessor: "label",
                        label: "label",
                        width: CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH,
                        minWidth: CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH,
                        isInlineEditable: false,
                        isRowIndexColumn: false,
                        isWidthPinned: true,
                        isWidthConstant: true,
                        dataType: undefined,
                    },
                    {
                        accessor: "part",
                        label: "part",
                        width: undefined,
                        minWidth: CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH,
                        isInlineEditable: false,
                        isRowIndexColumn: false,
                        dataType: undefined,
                    },
                ],
            },
        ];
    }, [conditionalExpression, expressionHolderId]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.SecondToLastLevel;
    }, [isNested]);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange: onColumnResizingWidthChange } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        const nestedExpressions = [
            conditionalExpression.if.expression,
            conditionalExpression.then.expression,
            conditionalExpression.else.expression,
        ];
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH,
            fixedColumnResizingWidth: { value: CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH, isPivoting: false },
            fixedColumnMinWidth: CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH,
            nestedExpressionMinWidth: CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH,
            extraWidth: CONDITIONAL_EXPRESSION_EXTRA_WIDTH,
            expression: conditionalExpression,
            flexibleColumnIndex: 2,
            widthsById: widthsById,
        };
    }, [conditionalExpression, widthsById]));
    const allowedOperations = useCallback(() => {
        return [BeeTableOperation.SelectionCopy, BeeTableOperation.RowReset];
    }, []);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.contextEntry,
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
        ];
    }, [i18n]);
    const onRowReset = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                if (args.rowIndex === 0) {
                    const ret = {
                        ...prev,
                        if: {
                            "@_id": generateUuid(),
                            expression: undefined,
                        },
                    };
                    return ret;
                }
                else if (args.rowIndex === 1) {
                    const ret = {
                        ...prev,
                        then: {
                            "@_id": generateUuid(),
                            expression: undefined,
                        },
                    };
                    return ret;
                }
                else if (args.rowIndex === 2) {
                    const ret = {
                        ...prev,
                        else: {
                            "@_id": generateUuid(),
                            expression: undefined,
                        },
                    };
                    return ret;
                }
                else {
                    throw new Error("ConditionalExpression shouldn't have more than 3 rows.");
                }
            },
            expressionChangedArgs: { action: Action.RowReset, rowIndex: args.rowIndex },
        });
    }, [setExpression]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        var _a, _b;
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: expressionHolderId,
            typeChange: typeRef !== conditionalExpression["@_typeRef"]
                ? {
                    from: (_a = conditionalExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "",
                    to: typeRef,
                }
                : undefined,
            nameChange: name !== conditionalExpression["@_label"]
                ? {
                    from: (_b = conditionalExpression["@_label"]) !== null && _b !== void 0 ? _b : "",
                    to: name,
                }
                : undefined,
        };
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_label": name,
                    "@_typeRef": typeRef,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [conditionalExpression, expressionHolderId, setExpression]);
    const getRowKey = useCallback((row) => {
        return row.original.part["@_id"];
    }, []);
    const supportsEvaluationHitsCount = useCallback((row) => {
        return row.original.label !== "if";
    }, []);
    return (_jsx(NestedExpressionContainerContext.Provider, { value: nestedExpressionContainerValue, children: _jsx("div", { className: "conditional-expression", "data-testid": "kie-tools--boxed-expression-component---conditional", children: _jsx(BeeTable, { isReadOnly: isReadOnly, isEditableHeader: !isReadOnly, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: id, getRowKey: getRowKey, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: headerVisibility, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: tableColumns, rows: tableRows, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, onRowReset: onRowReset, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false, supportsEvaluationHitsCount: supportsEvaluationHitsCount }) }) }));
}
//# sourceMappingURL=ConditionalExpression.js.map