import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { FileStatusOnPr } from "./FileStatusOnPr";
import { useChromeExtensionI18n } from "../../i18n";
export function PrToolbar(props) {
    const { i18n } = useChromeExtensionI18n();
    const closeDiagram = (e) => {
        e.preventDefault();
        props.closeDiagram();
    };
    const seeAsDiagram = (e) => {
        e.preventDefault();
        props.onSeeAsDiagram();
    };
    const toggleOriginal = (e) => {
        e.preventDefault();
        props.toggleOriginal();
    };
    return (_jsxs(_Fragment, { children: [!props.textMode && (_jsx("button", { disabled: props.textMode, className: "btn btn-sm kogito-button", onClick: closeDiagram, children: i18n.pr.toolbar.closeDiagram })), props.textMode && (_jsx("button", { className: "btn btn-sm kogito-button", onClick: seeAsDiagram, children: i18n.seeAsDiagram })), !props.textMode && props.fileStatusOnPr === FileStatusOnPr.CHANGED && props.showOriginalChangesToggle && (_jsxs("div", { className: "BtnGroup mr-1", children: [_jsx("button", { disabled: props.originalDiagram, className: "btn btn-sm BtnGroup-item " + (props.originalDiagram ? "disabled" : ""), type: "button", onClick: toggleOriginal, children: i18n.pr.toolbar.original }), _jsx("button", { disabled: !props.originalDiagram, className: "btn btn-sm BtnGroup-item " + (!props.originalDiagram ? "disabled" : ""), type: "button", onClick: toggleOriginal, children: i18n.pr.toolbar.changes })] }))] }));
}
//# sourceMappingURL=PrToolbar.js.map