import { ConstraintType } from "./DataDictionaryContainer/DataDictionaryContainer";
export const convertPMML2DD = (PMMLDataDictionary) => {
    if (PMMLDataDictionary === undefined) {
        return [];
    }
    else {
        return PMMLDataDictionary.DataField.filter((item) => item.dataType !== undefined).map((item) => {
            return convertFromDataField(item);
        });
    }
};
export const convertToDataField = (item) => {
    const convertedField = {
        name: item.name,
        dataType: item.type,
        optype: item.optype,
    };
    convertedField.displayName = item.displayName;
    if (item.isCyclic !== undefined) {
        convertedField.isCyclic = item.isCyclic ? "1" : "0";
    }
    if (item.missingValue) {
        convertedField.Value = convertedField.Value || [];
        convertedField.Value.push({
            property: "missing",
            value: item.missingValue,
        });
    }
    if (item.invalidValue) {
        convertedField.Value = convertedField.Value || [];
        convertedField.Value.push({
            property: "invalid",
            value: item.invalidValue,
        });
    }
    if (item.constraints) {
        if (item.constraints.type === ConstraintType.RANGE && item.constraints.value.length > 0) {
            convertedField.Interval = item.constraints.value.map((range) => {
                var _a, _b;
                const interval = {
                    closure: `${((_a = range === null || range === void 0 ? void 0 : range.start) === null || _a === void 0 ? void 0 : _a.included) ? "closed" : "open"}${((_b = range === null || range === void 0 ? void 0 : range.end) === null || _b === void 0 ? void 0 : _b.included) ? "Closed" : "Open"}`,
                };
                if (range.start && range.start.value) {
                    interval.leftMargin = Number(range.start.value);
                }
                if (range.end && range.end.value) {
                    interval.rightMargin = Number(range.end.value);
                }
                return interval;
            });
        }
        if (item.constraints.type === ConstraintType.ENUMERATION && item.constraints.value.length > 0) {
            convertedField.Value = (convertedField.Value || []).concat(item.constraints.value.map((value) => {
                return { value };
            }));
        }
    }
    return convertedField;
};
export const convertFromDataField = (item) => {
    let type;
    if (item.dataType === "string" ||
        item.dataType === "integer" ||
        item.dataType === "float" ||
        item.dataType === "double" ||
        item.dataType === "boolean") {
        type = item.dataType;
    }
    else {
        type = "string";
    }
    const convertedField = {
        name: item.name,
        type: type,
        optype: item.optype,
    };
    if (item.displayName) {
        convertedField.displayName = item.displayName;
    }
    if (item.isCyclic !== undefined) {
        convertedField.isCyclic = item.isCyclic === "1";
    }
    if (item.Value) {
        item.Value.forEach((value) => {
            if (value.property === "missing") {
                convertedField.missingValue = value.value;
            }
            if (value.property === "invalid") {
                convertedField.invalidValue = value.value;
            }
            if (value.property === "valid" || value.property === undefined) {
                convertedField.constraints = convertedField.constraints || {
                    type: ConstraintType.ENUMERATION,
                    value: [],
                };
                convertedField.constraints.value.push(value.value);
            }
        });
    }
    if (item.Interval && item.Interval.length > 0) {
        convertedField.constraints = {
            type: ConstraintType.RANGE,
            value: item.Interval.map((interval) => {
                var _a, _b, _c, _d;
                return {
                    start: {
                        value: (_b = (_a = interval.leftMargin) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "",
                        included: interval.closure.startsWith("closed"),
                    },
                    end: {
                        value: (_d = (_c = interval.rightMargin) === null || _c === void 0 ? void 0 : _c.toString()) !== null && _d !== void 0 ? _d : "",
                        included: interval.closure.endsWith("Closed"),
                    },
                };
            }),
        };
    }
    return convertedField;
};
//# sourceMappingURL=dataDictionaryUtils.js.map