import * as React from "react";
import { UnitablesI18n } from "./i18n";
import { UnitablesJsonSchemaBridge } from "./uniforms";
import "./Unitables.css";
import { UnitablesInputsConfigs } from "./UnitablesTypes";
export interface UnitablesProps {
    rows: Array<Record<string, any>>;
    setRows: (previousStateFunction: ((previous: Array<Record<string, any>>) => Array<Record<string, any>>) | Array<Record<string, any>>) => void;
    error: boolean;
    setError: React.Dispatch<React.SetStateAction<boolean>>;
    openRow: (rowIndex: number) => void;
    i18n: UnitablesI18n;
    jsonSchemaBridge: UnitablesJsonSchemaBridge;
    scrollableParentRef: React.RefObject<HTMLElement>;
    onRowAdded: (args: {
        beforeIndex: number;
    }) => void;
    onRowDuplicated: (args: {
        rowIndex: number;
    }) => void;
    onRowReset: (args: {
        rowIndex: number;
    }) => void;
    onRowDeleted: (args: {
        rowIndex: number;
    }) => void;
    configs: UnitablesInputsConfigs;
    setWidth: (newWidth: number, fieldName: string) => void;
}
export declare const Unitables: ({ rows, setRows, openRow, i18n, jsonSchemaBridge, scrollableParentRef, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, configs, setWidth, }: UnitablesProps) => JSX.Element;
//# sourceMappingURL=Unitables.d.ts.map