import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback, useImperativeHandle, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { TaskFormEnvelopeViewDriver } from "./TaskFormEnvelopeViewDriver";
import CustomTaskFormDisplayer from "./components/CustomTaskFormDisplayer/CustomTaskFormDisplayer";
import TaskForm from "./components/TaskForm/TaskForm";
import "@patternfly/patternfly/patternfly.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import { filterTaskPhases } from "./components/TaskFormRenderer/TaskPhasesUtils";
export const TaskFormEnvelopeView = React.forwardRef(({ channelApi, targetOrigin, ouiaId, ouiaSafe }, forwardedRef) => {
    const [isLoading, setIsLoading] = useState(true);
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [userTask, setUserTask] = useState();
    const [user, setUser] = useState();
    const [taskFormSchema, setTaskFormSchema] = useState();
    const [customForm, setCustomForm] = useState();
    const [userTaskPhases, setUserTaskPhases] = useState([]);
    const [driver] = useState(new TaskFormEnvelopeViewDriver(channelApi));
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(true);
            setUserTask(initArgs.userTask);
            setUser(initArgs.user);
        },
    }), []);
    useCancelableEffect(useCallback(({ canceled }) => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
        }
        else {
            const customFormPromise = new Promise((resolve) => {
                driver
                    .getCustomForm()
                    .then((customForm) => {
                    if (canceled.get()) {
                        return;
                    }
                    setCustomForm(customForm);
                    resolve();
                })
                    .catch((error) => resolve());
            });
            const schemaPromise = new Promise((resolve) => {
                driver
                    .getTaskFormSchema()
                    .then((schema) => {
                    if (canceled.get()) {
                        return;
                    }
                    setTaskFormSchema(schema);
                    resolve();
                })
                    .catch((error) => resolve());
            });
            const phasesPromise = new Promise((resolve) => {
                driver
                    .getTaskPhases()
                    .then((phases) => {
                    if (canceled.get()) {
                        return;
                    }
                    setUserTaskPhases(filterTaskPhases(phases));
                    resolve();
                })
                    .catch((error) => resolve());
            });
            Promise.all([customFormPromise, schemaPromise, phasesPromise]).then((values) => {
                setIsLoading(false);
            });
        }
    }, [driver, isEnvelopeConnectedToChannel]));
    if (isLoading) {
        return (_jsx(Bullseye, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-loading-spinner", "task-form", true), children: _jsx(KogitoSpinner, { spinnerText: `Loading Task form...` }) }));
    }
    if (taskFormSchema) {
        if (customForm) {
            return (_jsx(CustomTaskFormDisplayer, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-custom-task-form", "custom-task-form", ouiaSafe), userTask: userTask, schema: taskFormSchema, customForm: customForm, user: user, driver: driver, phases: userTaskPhases, targetOrigin: targetOrigin }));
        }
        return (_jsx(TaskForm, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-task-form", "task-form", ouiaSafe), userTask: userTask, schema: taskFormSchema, phases: userTaskPhases, driver: driver }));
    }
    return (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Info, title: "No form to show", body: `Cannot find form for task  ${userTask.referenceName} (${userTask.id.substring(0, 5)})`, ...componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-no-form", "empty-task-form", ouiaSafe) }));
});
export default TaskFormEnvelopeView;
//# sourceMappingURL=TaskFormEnvelopeView.js.map