export function computeAllFeelVariableUniqueNames(drgElements, imports) {
    const ret = new Map();
    drgElements !== null && drgElements !== void 0 ? drgElements : (drgElements = []);
    imports !== null && imports !== void 0 ? imports : (imports = []);
    for (let i = 0; i < drgElements.length; i++) {
        const drgElement = drgElements[i];
        ret.set(drgElement["@_name"], drgElement["@_id"]);
    }
    for (let i = 0; i < imports.length; i++) {
        const _import = imports[i];
        ret.set(_import["@_name"], _import["@_id"]);
    }
    return ret;
}
//# sourceMappingURL=computeAllFeelVariableUniqueNames.js.map