import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { updateTextAnnotation } from "../mutations/renameNode";
import { useSettings } from "../settings/DmnEditorSettingsContext";
export function TextAnnotationProperties({ textAnnotation, index, }) {
    var _a, _b;
    const { setState } = useDmnEditorStoreApi();
    const settings = useSettings();
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "Format", children: _jsx(TextInput, { "aria-label": "Format", type: "text", isDisabled: settings.isReadOnly, value: textAnnotation["@_textFormat"], placeholder: "Enter a text format...", onChange: (newTextFormat) => {
                        setState((state) => {
                            state.dmn.model.definitions.artifact[index]["@_textFormat"] =
                                newTextFormat;
                        });
                    } }) }), _jsx(FormGroup, { label: "Text", children: _jsx(TextArea, { "aria-label": "Text", type: "text", isDisabled: settings.isReadOnly, value: (_a = textAnnotation.text) === null || _a === void 0 ? void 0 : _a.__$$text, onChange: (newText) => {
                        setState((state) => {
                            updateTextAnnotation({
                                definitions: state.dmn.model.definitions,
                                index,
                                newText,
                            });
                        });
                    }, placeholder: "Enter text...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: settings.isReadOnly, value: (_b = textAnnotation.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: (newDescription) => {
                        setState((state) => {
                            state.dmn.model.definitions.artifact[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 2 }) }), _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: textAnnotation["@_id"] }) })] }));
}
//# sourceMappingURL=TextAnnotationProperties.js.map