import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { DescriptionField, ExpressionLanguageField } from "../Fields";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
export function LiteralExpressionContentCell(props) {
    var _a, _b, _c, _d, _e, _f;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), _jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_b = cell["@_expressionLanguage"]) !== null && _b !== void 0 ? _b : "", expressionPath: (_c = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _c !== void 0 ? _c : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                    dmnObject["@_expressionLanguage"] = newExpressionLanguage;
                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_e = (_d = cell.description) === null || _d === void 0 ? void 0 : _d.__$$text) !== null && _e !== void 0 ? _e : "", expressionPath: (_f = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _f !== void 0 ? _f : [], onChange: (newDescription) => updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                }) })] }));
}
//# sourceMappingURL=LiteralExpressionContentCell.js.map