import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { DescriptionField, NameField, TypeRefField } from "../Fields";
import { useDmnEditor } from "../../DmnEditorContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { Text } from "@patternfly/react-core/dist/js/components/Text";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function FunctionDefinitionParameterCell(props) {
    var _a;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    const [isParameterExpanded, setParameterExpaded] = useState([]);
    const getAllUniqueNames = useCallback((s) => new Map(), []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), cell.length === 0 && (_jsx(_Fragment, { children: _jsx(Text, { children: "Empty parameters list" }) })), cell.map((parameter, i) => {
                var _a, _b, _c, _d, _e;
                return (_jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: (_a = isParameterExpanded[i]) !== null && _a !== void 0 ? _a : false, toogleSectionExpanded: () => setParameterExpaded((prev) => {
                                var _a;
                                const newExpanded = [...prev];
                                newExpanded[i] = !((_a = newExpanded[i]) !== null && _a !== void 0 ? _a : false);
                                return newExpanded;
                            }), title: _jsxs("p", { children: ["Parameter ", _jsx("b", { children: parameter["@_name"] })] }) }), isParameterExpanded[i] && (_jsxs(_Fragment, { children: [_jsx(NameField, { isReadOnly: props.isReadOnly, id: parameter["@_id"], name: (_b = parameter["@_name"]) !== null && _b !== void 0 ? _b : "", getAllUniqueNames: getAllUniqueNames, onChange: (newName) => {
                                        updater((dmnObject) => {
                                            var _a, _b;
                                            var _c;
                                            (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                            (_b = (_c = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_c[i] = { "@_id": generateUuid(), "@_name": "" });
                                            dmnObject.formalParameter[i]["@_name"] = newName;
                                        });
                                    } }), _jsx(FunctionDefinitionParameterTypeRef, { parameter: parameter, isReadOnly: props.isReadOnly, onTypeRefChange: (newTypeRef) => updater((dmnObject) => {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                        (_b = (_c = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_c[i] = { "@_id": generateUuid(), "@_name": "" });
                                        dmnObject.formalParameter[i]["@_typeRef"] = newTypeRef;
                                    }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_d = (_c = parameter.description) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "", expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [], onChange: (newDescription) => {
                                        updater((dmnObject) => {
                                            var _a, _b, _c;
                                            var _d, _e;
                                            (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                            (_b = (_d = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_d[i] = {
                                                "@_id": generateUuid(),
                                                "@_name": "",
                                                description: { __$$text: "" },
                                            });
                                            (_c = (_e = dmnObject.formalParameter[i]).description) !== null && _c !== void 0 ? _c : (_e.description = { __$$text: "" });
                                            dmnObject.formalParameter[i].description.__$$text = newDescription;
                                        });
                                    } })] }))] }, i));
            })] }));
}
function FunctionDefinitionParameterTypeRef(props) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const { dmnEditorRootElementRef } = useDmnEditor();
    const itemDefinition = useMemo(() => {
        var _a, _b, _c, _d;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace);
        return (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = props.parameter) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition;
    }, [dmnEditorStoreApi, externalModelsByNamespace, props.parameter]);
    return (_jsxs(_Fragment, { children: [_jsx(TypeRefField, { isReadOnly: props.isReadOnly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: props.parameter["@_typeRef"], onChange: props.onTypeRefChange }), itemDefinition && (_jsx(FormGroup, { label: "Constraint", children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: true, itemDefinition: itemDefinition, editItemDefinition: () => { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) }))] }));
}
//# sourceMappingURL=FunctionDefinitionParametersCell.js.map