export function setDrgElementExpression({ definitions, expression, drgElementIndex, }) {
    var _a;
    const drgElement = (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex];
    if (!drgElement) {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that doesn't exist.");
    }
    if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "decision") {
        drgElement.expression = expression;
    }
    else if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "businessKnowledgeModel") {
        if (expression.__$$element !== "functionDefinition") {
            throw new Error("DMN MUTATION: Can't have an expression on a BKM that is not a Function.");
        }
        if (!(expression === null || expression === void 0 ? void 0 : expression.__$$element)) {
            throw new Error("DMN MUTATION: Can't determine expression type without its __$$element property.");
        }
        const { __$$element, ..._updateExpression } = expression;
        drgElement.encapsulatedLogic = _updateExpression;
    }
    else {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that is not a Decision or a BKM.");
    }
}
//# sourceMappingURL=setDrgElementExpression.js.map