import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefToQName";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
export var EdgeDeletionMode;
(function (EdgeDeletionMode) {
    EdgeDeletionMode[EdgeDeletionMode["FROM_DRG_AND_ALL_DRDS"] = 0] = "FROM_DRG_AND_ALL_DRDS";
    EdgeDeletionMode[EdgeDeletionMode["FROM_CURRENT_DRD_ONLY"] = 1] = "FROM_CURRENT_DRD_ONLY";
})(EdgeDeletionMode || (EdgeDeletionMode = {}));
export function deleteEdge({ definitions, drdIndex, edge, mode, externalModelsByNamespace, }) {
    var _a, _b, _c, _d;
    if (edge.dmnObject.namespace === definitions["@_namespace"]) {
        const dmnObjects = (_a = switchExpression(edge === null || edge === void 0 ? void 0 : edge.dmnObject.type, {
            association: definitions.artifact,
            group: definitions.artifact,
            default: definitions.drgElement,
        })) !== null && _a !== void 0 ? _a : [];
        const dmnObjectIndex = dmnObjects.findIndex((d) => d["@_id"] === edge.dmnObject.id);
        if (dmnObjectIndex < 0) {
            throw new Error(`DMN MUTATION: Can't find DMN element with ID ${edge.dmnObject.id}`);
        }
        if (mode === EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
            const requirements = (_b = switchExpression(edge === null || edge === void 0 ? void 0 : edge.dmnObject.requirementType, {
                informationRequirement: dmnObjects[dmnObjectIndex].informationRequirement,
                knowledgeRequirement: dmnObjects[dmnObjectIndex].knowledgeRequirement,
                authorityRequirement: dmnObjects[dmnObjectIndex].authorityRequirement,
                association: dmnObjects,
            })) !== null && _b !== void 0 ? _b : [];
            const requirementIndex = (requirements !== null && requirements !== void 0 ? requirements : []).findIndex((d) => d["@_id"] === edge.id);
            if (requirementIndex >= 0) {
                requirements === null || requirements === void 0 ? void 0 : requirements.splice(requirementIndex, 1);
            }
        }
    }
    let deletedDmnEdgeOnCurrentDrd;
    const drdCount = ((_d = (_c = definitions["dmndi:DMNDI"]) === null || _c === void 0 ? void 0 : _c["dmndi:DMNDiagram"]) !== null && _d !== void 0 ? _d : []).length;
    for (let i = 0; i < drdCount; i++) {
        const { diagramElements } = addOrGetDrd({ definitions, drdIndex: i });
        if (mode === EdgeDeletionMode.FROM_CURRENT_DRD_ONLY && i !== drdIndex) {
            continue;
        }
        const dmnEdgeIndex = (diagramElements !== null && diagramElements !== void 0 ? diagramElements : []).findIndex((d) => d["@_dmnElementRef"] === xmlHrefToQName(edge.id, definitions));
        if (dmnEdgeIndex >= 0) {
            if (i === drdIndex) {
                deletedDmnEdgeOnCurrentDrd = diagramElements[dmnEdgeIndex];
            }
            diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.splice(dmnEdgeIndex, 1);
        }
    }
    repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions, externalModelsByNamespace });
    return { deletedDmnEdgeOnCurrentDrd };
}
//# sourceMappingURL=deleteEdge.js.map