import * as RF from "reactflow";
export function getDiscretelyAutoPositionedEdgeParams(src, tgt) {
    const [sx, sy, sourcePos] = getPositionalHandlePosition(src, tgt);
    const [tx, ty, targetPos] = getPositionalHandlePosition(tgt, src);
    return { sx, sy, tx, ty, sourcePos, targetPos };
}
export function getPositionalHandlePosition(a, b) {
    const centerA = getCenter(a.x, a.y, a.width, a.height);
    const centerB = getCenter(b.x, b.y, b.width, b.height);
    const horizontalDiff = Math.abs(centerA.x - centerB.x);
    const verticalDiff = Math.abs(centerA.y - centerB.y);
    let position;
    if (horizontalDiff > verticalDiff) {
        position = centerA.x > centerB.x ? RF.Position.Left : RF.Position.Right;
    }
    else {
        position = centerA.y > centerB.y ? RF.Position.Top : RF.Position.Bottom;
    }
    const [x, y] = getHandleCoordsByPosition(a, position);
    return [x, y, position];
}
export function getCenter(x, y, width, height) {
    return {
        x: (x !== null && x !== void 0 ? x : 0) + (width !== null && width !== void 0 ? width : 0) / 2,
        y: (y !== null && y !== void 0 ? y : 0) + (height !== null && height !== void 0 ? height : 0) / 2,
    };
}
export function scaleFromCenter(amount, node) {
    var _a, _b, _c, _d, _e, _f;
    return {
        position: {
            x: ((_b = (_a = node.position) === null || _a === void 0 ? void 0 : _a.x) !== null && _b !== void 0 ? _b : 0) - amount,
            y: ((_d = (_c = node.position) === null || _c === void 0 ? void 0 : _c.y) !== null && _d !== void 0 ? _d : 0) - amount,
        },
        dimensions: {
            width: ((_e = node.dimensions.width) !== null && _e !== void 0 ? _e : 0) + amount * 2,
            height: ((_f = node.dimensions.height) !== null && _f !== void 0 ? _f : 0) + amount * 2,
        },
    };
}
function getHandleCoordsByPosition(node, handlePosition) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    let handleX = 0;
    let handleY = 0;
    switch (handlePosition) {
        case RF.Position.Left:
            handleX = 0;
            handleY = ((_a = node.height) !== null && _a !== void 0 ? _a : 0) / 2;
            break;
        case RF.Position.Right:
            handleX = (_b = node.width) !== null && _b !== void 0 ? _b : 0;
            handleY = ((_c = node.height) !== null && _c !== void 0 ? _c : 0) / 2;
            break;
        case RF.Position.Top:
            handleX = ((_d = node.width) !== null && _d !== void 0 ? _d : 0) / 2;
            handleY = 0;
            break;
        case RF.Position.Bottom:
            handleX = ((_e = node.width) !== null && _e !== void 0 ? _e : 0) / 2;
            handleY = (_f = node.height) !== null && _f !== void 0 ? _f : 0;
            break;
    }
    return [((_g = node === null || node === void 0 ? void 0 : node.x) !== null && _g !== void 0 ? _g : 0) + handleX, ((_h = node === null || node === void 0 ? void 0 : node.y) !== null && _h !== void 0 ? _h : 0) + handleY];
}
export function getBoundsCenterPoint(node) {
    const { x, y } = getCenter(node === null || node === void 0 ? void 0 : node.x, node === null || node === void 0 ? void 0 : node.y, node === null || node === void 0 ? void 0 : node.width, node === null || node === void 0 ? void 0 : node.height);
    return { "@_x": x, "@_y": y };
}
//# sourceMappingURL=Maths.js.map