export function snapShapePosition(snapGrid, shape) {
    return snapBoundsPosition(snapGrid, shape["dc:Bounds"]);
}
export function snapBoundsPosition(snapGrid, bounds) {
    return {
        x: snap(snapGrid, "x", bounds === null || bounds === void 0 ? void 0 : bounds["@_x"]),
        y: snap(snapGrid, "y", bounds === null || bounds === void 0 ? void 0 : bounds["@_y"]),
    };
}
export function offsetShapePosition(shape, offset) {
    if (!shape["dc:Bounds"]) {
        return shape;
    }
    return {
        ...shape,
        "dc:Bounds": {
            ...shape["dc:Bounds"],
            "@_x": offset.x + shape["dc:Bounds"]["@_x"],
            "@_y": offset.y + shape["dc:Bounds"]["@_y"],
        },
    };
}
export function snapShapeDimensions(grid, shape, minSizes) {
    return snapBoundsDimensions(grid, shape["dc:Bounds"], minSizes);
}
export function snapBoundsDimensions(grid, bounds, minSizes) {
    return {
        width: Math.max(snap(grid, "x", bounds === null || bounds === void 0 ? void 0 : bounds["@_width"]), minSizes["@_width"]),
        height: Math.max(snap(grid, "y", bounds === null || bounds === void 0 ? void 0 : bounds["@_height"]), minSizes["@_height"]),
    };
}
export function snapPoint(grid, point, method = "round") {
    return {
        "@_x": snap(grid, "x", point === null || point === void 0 ? void 0 : point["@_x"], method),
        "@_y": snap(grid, "y", point === null || point === void 0 ? void 0 : point["@_y"], method),
    };
}
export function snap(grid, coord, value, method = "round") {
    return grid.isEnabled
        ? Math[method]((value !== null && value !== void 0 ? value : 0) / grid[coord]) * grid[coord]
        : value !== null && value !== void 0 ? value : 0;
}
//# sourceMappingURL=SnapGrid.js.map