import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as RF from "reactflow";
import { useOnViewportChange } from "reactflow";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { normalize } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { buildXmlHref, parseXmlHref, xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, EmptyStateVariant, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { BlueprintIcon } from "@patternfly/react-icons/dist/js/icons/blueprint-icon";
import { InfoIcon } from "@patternfly/react-icons/dist/js/icons/info-icon";
import { MousePointerIcon } from "@patternfly/react-icons/dist/js/icons/mouse-pointer-icon";
import { TableIcon } from "@patternfly/react-icons/dist/js/icons/table-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { VirtualMachineIcon } from "@patternfly/react-icons/dist/js/icons/virtual-machine-icon";
import { useDmnEditor } from "../DmnEditorContext";
import { AutolayoutButton } from "../autolayout/AutolayoutButton";
import { getDefaultColumnWidth } from "@kie-tools/boxed-expression-component/dist/resizing/WidthsToFitData";
import { getDefaultBoxedExpression } from "../boxedExpressions/getDefaultBoxedExpression";
import { MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS, } from "../externalNodes/ExternalNodesPanel";
import { nodeNatures } from "../mutations/NodeNature";
import { addConnectedNode } from "../mutations/addConnectedNode";
import { addDecisionToDecisionService } from "../mutations/addDecisionToDecisionService";
import { addEdge } from "../mutations/addEdge";
import { addShape } from "../mutations/addShape";
import { addStandaloneNode } from "../mutations/addStandaloneNode";
import { deleteDecisionFromDecisionService } from "../mutations/deleteDecisionFromDecisionService";
import { deleteEdge, EdgeDeletionMode } from "../mutations/deleteEdge";
import { deleteNode, NodeDeletionMode } from "../mutations/deleteNode";
import { repositionNode } from "../mutations/repositionNode";
import { resizeNode } from "../mutations/resizeNode";
import { updateExpression } from "../mutations/updateExpression";
import { OverlaysPanel } from "../overlaysPanel/OverlaysPanel";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { DiagramContainerContextProvider } from "./DiagramContainerContext";
import { MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE } from "./DrgNodesPanel";
import { MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE, Palette } from "./Palette";
import { offsetShapePosition, snapShapeDimensions, snapShapePosition } from "./SnapGrid";
import { ConnectionLine } from "./connections/ConnectionLine";
import { PositionalNodeHandleId } from "./connections/PositionalNodeHandles";
import { containment, getDefaultEdgeTypeBetween } from "./connections/graphStructure";
import { checkIsValidConnection } from "./connections/isValidConnection";
import { EdgeMarkers } from "./edges/EdgeMarkers";
import { EDGE_TYPES } from "./edges/EdgeTypes";
import { AssociationEdge, AuthorityRequirementEdge, InformationRequirementEdge, KnowledgeRequirementEdge, } from "./edges/Edges";
import { buildHierarchy } from "./graph/graph";
import { getContainmentRelationship, getDmnBoundsCenterPoint, getHandlePosition, getNodeTypeFromDmnObject, } from "./maths/DmnMaths";
import { DEFAULT_NODE_SIZES, MIN_NODE_SIZES } from "./nodes/DefaultSizes";
import { NODE_TYPES } from "./nodes/NodeTypes";
import { BkmNode, DecisionNode, DecisionServiceNode, GroupNode, InputDataNode, KnowledgeSourceNode, TextAnnotationNode, UnknownNode, } from "./nodes/Nodes";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { addAutoGeneratedDecisionServiceToDrd, addConflictingDecisionServiceToDrd, addExistingDecisionServiceToDrd, getDecisionServicePropertiesRelativeToThisDmn, getStrategyToAddExistingDecisionServiceToDrd, StrategyForAddingDecisionServiceToDrd, } from "../mutations/addExistingDecisionServiceToDrd";
import { updateExpressionWidths } from "../mutations/updateExpressionWidths";
import { DiagramCommands } from "./DiagramCommands";
import { getAutoLayoutedInfo } from "../autolayout/autoLayoutInfo";
import { autoGenerateDrd } from "../normalization/autoGenerateDrd";
import OptimizeIcon from "@patternfly/react-icons/dist/js/icons/optimize-icon";
import { applyAutoLayoutToDrd } from "../mutations/applyAutoLayoutToDrd";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { EvaluationHighlightsBadge } from "../evaluationHighlights/EvaluationHighlightsBadge";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
const isFirefox = typeof window.InstallTrigger !== "undefined";
const PAN_ON_DRAG = [1, 2];
const FIT_VIEW_OPTIONS = { maxZoom: 1, minZoom: 0.1, duration: 400 };
export const DEFAULT_VIEWPORT = { x: 100, y: 100, zoom: 1 };
const DELETE_NODE_KEY_CODES = ["Backspace", "Delete"];
const AREA_ABOVE_OVERLAYS_PANEL = 120;
const nodeTypes = {
    [NODE_TYPES.decisionService]: DecisionServiceNode,
    [NODE_TYPES.group]: GroupNode,
    [NODE_TYPES.inputData]: InputDataNode,
    [NODE_TYPES.decision]: DecisionNode,
    [NODE_TYPES.bkm]: BkmNode,
    [NODE_TYPES.knowledgeSource]: KnowledgeSourceNode,
    [NODE_TYPES.textAnnotation]: TextAnnotationNode,
    [NODE_TYPES.unknown]: UnknownNode,
};
const edgeTypes = {
    [EDGE_TYPES.informationRequirement]: InformationRequirementEdge,
    [EDGE_TYPES.authorityRequirement]: AuthorityRequirementEdge,
    [EDGE_TYPES.knowledgeRequirement]: KnowledgeRequirementEdge,
    [EDGE_TYPES.association]: AssociationEdge,
};
export const Diagram = React.forwardRef(({ container }, ref) => {
    var _a;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const settings = useSettings();
    const { dmnModelBeforeEditingRef } = useDmnEditor();
    const [reactFlowInstance, setReactFlowInstance] = useState(undefined);
    const viewport = useDmnEditorStore((s) => s.diagram.viewport);
    React.useImperativeHandle(ref, () => ({
        getReactFlowInstance: () => {
            return reactFlowInstance;
        },
    }), [reactFlowInstance]);
    const nodeIdBeingDraggedRef = useRef(null);
    const rfSnapGrid = useMemo(() => (snapGrid.isEnabled ? [snapGrid.x, snapGrid.y] : [1, 1]), [snapGrid.isEnabled, snapGrid.x, snapGrid.y]);
    const onConnect = useCallback(({ source, target, sourceHandle, targetHandle }) => {
        console.debug("DMN DIAGRAM: `onConnect`: ", { source, target, sourceHandle, targetHandle });
        dmnEditorStoreApi.setState((state) => {
            const sourceNode = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(source);
            const targetNode = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(target);
            if (!sourceNode || !targetNode) {
                throw new Error("Cannot create connection without target and source nodes!");
            }
            const sourceBounds = sourceNode.data.shape["dc:Bounds"];
            const targetBounds = targetNode.data.shape["dc:Bounds"];
            if (!sourceBounds || !targetBounds) {
                throw new Error("Cannot create connection without source and target bounds!");
            }
            addEdge({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edge: {
                    type: sourceHandle,
                    targetHandle: targetHandle,
                    sourceHandle: PositionalNodeHandleId.Center,
                    autoPositionedEdgeMarker: undefined,
                },
                sourceNode: {
                    type: sourceNode.type,
                    data: sourceNode.data,
                    href: sourceNode.id,
                    bounds: sourceBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                targetNode: {
                    type: targetNode.type,
                    href: targetNode.id,
                    data: targetNode.data,
                    bounds: targetBounds,
                    index: targetNode.data.index,
                    shapeId: targetNode.data.shape["@_id"],
                },
                keepWaypoints: false,
                externalModelsByNamespace,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    const getFirstNodeFittingBounds = useCallback((nodeIdToIgnore, bounds, minSizes, snapGrid) => reactFlowInstance === null || reactFlowInstance === void 0 ? void 0 : reactFlowInstance.getNodes().reverse().find((node) => node.id !== nodeIdToIgnore &&
        getContainmentRelationship({
            bounds: bounds,
            container: node.data.shape["dc:Bounds"],
            snapGrid,
            isAlternativeInputDataShape: dmnEditorStoreApi
                .getState()
                .computed(dmnEditorStoreApi.getState())
                .isAlternativeInputDataShape(),
            containerMinSizes: MIN_NODE_SIZES[node.type],
            boundsMinSizes: minSizes,
        }).isInside), [reactFlowInstance, dmnEditorStoreApi]);
    const onDragOver = useCallback((e) => {
        if (!e.dataTransfer.types.find((t) => t === MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE ||
            t === MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS ||
            t === MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE)) {
            return;
        }
        e.preventDefault();
        e.dataTransfer.dropEffect = "move";
    }, []);
    const onDrop = useCallback(async (e) => {
        var _a;
        e.preventDefault();
        if (!container.current || !reactFlowInstance) {
            return;
        }
        const dropPoint = reactFlowInstance.screenToFlowPosition({
            x: e.clientX,
            y: e.clientY,
        });
        if (e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE)) {
            const typeOfNewNodeFromPalette = e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE);
            e.stopPropagation();
            dmnEditorStoreApi.setState((state) => {
                const { id, href: newNodeId } = addStandaloneNode({
                    definitions: state.dmn.model.definitions,
                    drdIndex: state.computed(state).getDrdIndex(),
                    newNode: {
                        type: typeOfNewNodeFromPalette,
                        bounds: {
                            "@_x": dropPoint.x,
                            "@_y": dropPoint.y,
                            "@_width": DEFAULT_NODE_SIZES[typeOfNewNodeFromPalette]({
                                snapGrid: state.diagram.snapGrid,
                                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                            })["@_width"],
                            "@_height": DEFAULT_NODE_SIZES[typeOfNewNodeFromPalette]({
                                snapGrid: state.diagram.snapGrid,
                                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                            })["@_height"],
                        },
                    },
                    externalModelsByNamespace,
                });
                state.diagram._selectedNodes = [newNodeId];
                state.focus.consumableId = newNodeId;
            });
        }
        else if (e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS)) {
            e.stopPropagation();
            const externalNode = JSON.parse(e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS));
            const state = dmnEditorStoreApi.getState();
            const externalDmnsIndex = state
                .computed(state)
                .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns;
            const externalNodeDmn = externalDmnsIndex.get(externalNode.externalDrgElementNamespace);
            const externalDrgElement = ((_a = externalNodeDmn === null || externalNodeDmn === void 0 ? void 0 : externalNodeDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).find((e) => e["@_id"] === externalNode.externalDrgElementId);
            if (!externalNodeDmn || !externalDrgElement) {
                throw new Error(`Can't find DRG element with id '${externalNode.externalDrgElementId}' on/or model with namespace '${externalNode.externalDrgElementNamespace}'.`);
            }
            const externalNodeType = getNodeTypeFromDmnObject(externalDrgElement);
            const defaultExternalNodeDimensions = DEFAULT_NODE_SIZES[externalNodeType]({
                snapGrid: state.diagram.snapGrid,
                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
            });
            const externalNodeHref = buildXmlHref({
                namespace: externalNode.externalDrgElementNamespace,
                id: externalNode.externalDrgElementId,
            });
            if (externalDrgElement.__$$element === "decisionService") {
                const { computed, ...internalState } = state;
                const dereferencedState = { computed, ...JSON.parse(JSON.stringify(internalState)) };
                const drdIndex = dereferencedState.computed(dereferencedState).getDrdIndex();
                const { strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn, } = getStrategyToAddExistingDecisionServiceToDrd({
                    __readonly_definitions: dereferencedState.dmn.model.definitions,
                    __readonly_drgElement: externalDrgElement,
                    __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                    __readonly_drdIndex: drdIndex,
                    __readonly_externalDmnsIndex: externalDmnsIndex,
                    __readonly_indexedDrd: dereferencedState.computed(dereferencedState).indexedDrd(),
                    __readonly_namespace: dereferencedState.dmn.model.definitions["@_namespace"],
                });
                if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.CONFLICT) {
                    addConflictingDecisionServiceToDrd({
                        definitions: dereferencedState.dmn.model.definitions,
                        __readonly_drdIndex: drdIndex,
                        __readonly_dropPoint: dropPoint,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                    });
                }
                else if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE) {
                    await addAutoGeneratedDecisionServiceToDrd({
                        state: dereferencedState,
                        __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: externalDmnsIndex,
                        __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                        __readonly_snapGrid: dereferencedState.diagram.snapGrid,
                        __readonly_dropPoint: dropPoint,
                        __readonly_externalModelsByNamespace: externalModelsByNamespace,
                        __readonly_isAlternativeInputDataShape: dereferencedState
                            .computed(dereferencedState)
                            .isAlternativeInputDataShape(),
                    });
                }
                else if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD) {
                    addExistingDecisionServiceToDrd({
                        definitions: dereferencedState.dmn.model.definitions,
                        __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: dereferencedState
                            .computed(dereferencedState)
                            .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                        __readonly_indexedDrd: dereferencedState.computed(dereferencedState).indexedDrd(),
                        __readonly_indexedDrdContainingDecisionServiceDepiction: indexedDrdContainingDecisionServiceDepiction,
                        __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                        __readonly_dropPoint: dropPoint,
                        __readonly_namespace: dereferencedState.dmn.model.definitions["@_namespace"],
                    });
                }
                dmnEditorStoreApi.setState((state) => {
                    state.dmn.model = JSON.parse(JSON.stringify(dereferencedState.dmn.model));
                    state.diagram._selectedNodes = [externalNodeHref];
                });
            }
            else {
                dmnEditorStoreApi.setState((state) => {
                    const externalNodeType = getNodeTypeFromDmnObject(externalDrgElement);
                    addShape({
                        definitions: state.dmn.model.definitions,
                        drdIndex: state.computed(state).getDrdIndex(),
                        nodeType: externalNodeType,
                        shape: {
                            "@_id": generateUuid(),
                            "@_dmnElementRef": xmlHrefToQName(externalNodeHref, state.dmn.model.definitions),
                            "dc:Bounds": {
                                "@_x": dropPoint.x,
                                "@_y": dropPoint.y,
                                "@_width": defaultExternalNodeDimensions["@_width"],
                                "@_height": defaultExternalNodeDimensions["@_height"],
                            },
                        },
                    });
                    state.diagram._selectedNodes = [externalNodeHref];
                });
            }
            console.debug(`DMN DIAGRAM: Adding external node`, JSON.stringify(externalNode));
        }
        else if (e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE)) {
            const drgElement = JSON.parse(e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE));
            const nodeType = getNodeTypeFromDmnObject(drgElement);
            if (nodeType === undefined) {
                throw new Error("DMN DIAGRAM: It wasn't possible to determine the node type");
            }
            if (drgElement.__$$element === "decisionService") {
                const { computed, ...state } = dmnEditorStoreApi.getState();
                const dereferencedState = { computed, ...JSON.parse(JSON.stringify(state)) };
                const drdIndex = dereferencedState.computed(dereferencedState).getDrdIndex();
                const externalDmnsIndex = dereferencedState
                    .computed(dereferencedState)
                    .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns;
                const { strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn, } = getStrategyToAddExistingDecisionServiceToDrd({
                    __readonly_definitions: dereferencedState.dmn.model.definitions,
                    __readonly_drgElement: drgElement,
                    __readonly_decisionServiceNamespace: dereferencedState.dmn.model.definitions["@_namespace"],
                    __readonly_drdIndex: drdIndex,
                    __readonly_externalDmnsIndex: externalDmnsIndex,
                    __readonly_indexedDrd: dereferencedState.computed(dereferencedState).indexedDrd(),
                    __readonly_namespace: dereferencedState.dmn.model.definitions["@_namespace"],
                });
                if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.CONFLICT) {
                    addConflictingDecisionServiceToDrd({
                        definitions: dereferencedState.dmn.model.definitions,
                        __readonly_drdIndex: drdIndex,
                        __readonly_dropPoint: dropPoint,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                    });
                }
                else if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE) {
                    await addAutoGeneratedDecisionServiceToDrd({
                        state: dereferencedState,
                        __readonly_decisionServiceNamespace: dereferencedState.dmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: externalDmnsIndex,
                        __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                        __readonly_snapGrid: dereferencedState.diagram.snapGrid,
                        __readonly_dropPoint: dropPoint,
                        __readonly_externalModelsByNamespace: externalModelsByNamespace,
                        __readonly_isAlternativeInputDataShape: dereferencedState
                            .computed(dereferencedState)
                            .isAlternativeInputDataShape(),
                    });
                }
                else if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD) {
                    addExistingDecisionServiceToDrd({
                        definitions: dereferencedState.dmn.model.definitions,
                        __readonly_decisionServiceNamespace: dereferencedState.dmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: dereferencedState
                            .computed(dereferencedState)
                            .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                        __readonly_indexedDrd: dereferencedState.computed(dereferencedState).indexedDrd(),
                        __readonly_indexedDrdContainingDecisionServiceDepiction: indexedDrdContainingDecisionServiceDepiction,
                        __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                        __readonly_dropPoint: dropPoint,
                        __readonly_namespace: dereferencedState.dmn.model.definitions["@_namespace"],
                    });
                }
                dmnEditorStoreApi.setState((state) => {
                    state.dmn.model = JSON.parse(JSON.stringify(dereferencedState.dmn.model));
                });
            }
            else {
                dmnEditorStoreApi.setState((state) => {
                    const nodeType = getNodeTypeFromDmnObject(drgElement);
                    const defaultNodeDimensions = DEFAULT_NODE_SIZES[nodeType]({
                        snapGrid: state.diagram.snapGrid,
                        isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                    });
                    addShape({
                        definitions: state.dmn.model.definitions,
                        drdIndex: state.computed(state).getDrdIndex(),
                        nodeType,
                        shape: {
                            "@_id": generateUuid(),
                            "@_dmnElementRef": buildXmlQName({
                                type: "xml-qname",
                                localPart: drgElement["@_id"],
                            }),
                            "@_isCollapsed": false,
                            "dc:Bounds": {
                                "@_x": dropPoint.x,
                                "@_y": dropPoint.y,
                                "@_width": defaultNodeDimensions["@_width"],
                                "@_height": defaultNodeDimensions["@_height"],
                            },
                        },
                    });
                });
            }
            console.debug(`DMN DIAGRAM: Adding DRG node`, JSON.stringify(drgElement));
        }
    }, [container, dmnEditorStoreApi, externalModelsByNamespace, reactFlowInstance]);
    const ongoingConnection = useDmnEditorStore((s) => s.diagram.ongoingConnection);
    useEffect(() => {
        const edgeUpdaterSource = document.querySelectorAll(".react-flow__edgeupdater-source, .react-flow__edgeupdater-target");
        if (ongoingConnection) {
            edgeUpdaterSource.forEach((e) => e.classList.add("hidden"));
        }
        else {
            edgeUpdaterSource.forEach((e) => e.classList.remove("hidden"));
        }
    }, [ongoingConnection]);
    const onConnectStart = useCallback((e, newConnection) => {
        console.debug("DMN DIAGRAM: `onConnectStart`");
        dmnEditorStoreApi.setState((state) => {
            state.diagram.ongoingConnection = newConnection;
        });
    }, [dmnEditorStoreApi]);
    const onConnectEnd = useCallback((e) => {
        console.debug("DMN DIAGRAM: `onConnectEnd`");
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c;
            const targetIsPane = (_b = (_a = e.target) === null || _a === void 0 ? void 0 : _a.classList) === null || _b === void 0 ? void 0 : _b.contains("react-flow__pane");
            if (!targetIsPane || !container.current || !state.diagram.ongoingConnection || !reactFlowInstance) {
                return;
            }
            const dropPoint = reactFlowInstance.screenToFlowPosition({
                x: e.clientX,
                y: e.clientY,
            });
            if (!Object.values(NODE_TYPES).find((n) => n === state.diagram.ongoingConnection.handleId)) {
                return;
            }
            if (!state.diagram.ongoingConnection.nodeId) {
                return;
            }
            const sourceNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(state.diagram.ongoingConnection.nodeId);
            if (!sourceNode) {
                return;
            }
            const sourceNodeBounds = (_c = state.computed(state).indexedDrd().dmnShapesByHref.get(sourceNode.id)) === null || _c === void 0 ? void 0 : _c["dc:Bounds"];
            if (!sourceNodeBounds) {
                return;
            }
            const newNodeType = state.diagram.ongoingConnection.handleId;
            const sourceNodeType = sourceNode.type;
            const edgeType = getDefaultEdgeTypeBetween(sourceNodeType, newNodeType);
            if (!edgeType) {
                throw new Error(`DMN DIAGRAM: Invalid structure: ${sourceNodeType} --(any)--> ${newNodeType}`);
            }
            const { id, href: newDmnObejctHref } = addConnectedNode({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edgeType,
                sourceNode: {
                    href: sourceNode.id,
                    type: sourceNodeType,
                    bounds: sourceNodeBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                newNode: {
                    type: newNodeType,
                    bounds: {
                        "@_x": dropPoint.x,
                        "@_y": dropPoint.y,
                        "@_width": DEFAULT_NODE_SIZES[newNodeType]({
                            snapGrid: state.diagram.snapGrid,
                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        })["@_width"],
                        "@_height": DEFAULT_NODE_SIZES[newNodeType]({
                            snapGrid: state.diagram.snapGrid,
                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        })["@_height"],
                    },
                },
                externalModelsByNamespace,
            });
            state.diagram._selectedNodes = [newDmnObejctHref];
            state.focus.consumableId = newDmnObejctHref;
        });
        dmnEditorStoreApi.setState((state) => {
            state.diagram.ongoingConnection = undefined;
        });
    }, [dmnEditorStoreApi, container, reactFlowInstance, externalModelsByNamespace]);
    const isValidConnection = useCallback((edgeOrConnection) => {
        var _a, _b;
        const state = dmnEditorStoreApi.getState();
        const edgeId = state.diagram.edgeIdBeingUpdated;
        const edgeType = edgeId ? (_a = reactFlowInstance === null || reactFlowInstance === void 0 ? void 0 : reactFlowInstance.getEdge(edgeId)) === null || _a === void 0 ? void 0 : _a.type : undefined;
        const ongoingConnectionHierarchy = buildHierarchy({
            nodeId: (_b = state.diagram.ongoingConnection) === null || _b === void 0 ? void 0 : _b.nodeId,
            edges: state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges,
        });
        return (edgeOrConnection.source !== edgeOrConnection.target &&
            checkIsValidConnection(state.computed(state).getDiagramData(externalModelsByNamespace).nodesById, edgeOrConnection, edgeType) &&
            !!edgeOrConnection.target &&
            !ongoingConnectionHierarchy.dependencies.has(edgeOrConnection.target) &&
            !!edgeOrConnection.source &&
            !ongoingConnectionHierarchy.dependents.has(edgeOrConnection.source));
    }, [dmnEditorStoreApi, externalModelsByNamespace, reactFlowInstance]);
    const onNodesChange = useCallback((changes) => {
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j;
            const controlWaypointsByEdge = new Map();
            for (const change of changes) {
                switch (change.type) {
                    case "add":
                        console.debug(`DMN DIAGRAM: 'onNodesChange' --> add '${change.item.id}'`);
                        state.dispatch(state).diagram.setNodeStatus(change.item.id, { selected: true });
                        break;
                    case "dimensions":
                        console.debug(`DMN DIAGRAM: 'onNodesChange' --> dimensions '${change.id}'`);
                        state.dispatch(state).diagram.setNodeStatus(change.id, { resizing: change.resizing });
                        if (change.dimensions) {
                            const node = state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(change.id);
                            const snappedShape = snapShapeDimensions(state.diagram.snapGrid, node.data.shape, MIN_NODE_SIZES[node.type]({
                                snapGrid: state.diagram.snapGrid,
                                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                            }));
                            if (snappedShape.width !== change.dimensions.width ||
                                snappedShape.height !== change.dimensions.height) {
                                resizeNode({
                                    definitions: state.dmn.model.definitions,
                                    drdIndex: state.computed(state).getDrdIndex(),
                                    __readonly_dmnShapesByHref: state.computed(state).indexedDrd().dmnShapesByHref,
                                    snapGrid: state.diagram.snapGrid,
                                    __readonly_dmnObjectNamespace: node.data.dmnObjectNamespace,
                                    __readonly_externalDmnsIndex: state
                                        .computed(state)
                                        .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                                    change: {
                                        isExternal: !!node.data.dmnObjectQName.prefix,
                                        nodeType: node.type,
                                        index: node.data.index,
                                        shapeIndex: node.data.shape.index,
                                        sourceEdgeIndexes: state
                                            .computed(state)
                                            .getDiagramData(externalModelsByNamespace)
                                            .edges.flatMap((e) => { var _a; return e.source === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                        targetEdgeIndexes: state
                                            .computed(state)
                                            .getDiagramData(externalModelsByNamespace)
                                            .edges.flatMap((e) => { var _a; return e.target === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                        dimension: {
                                            "@_width": (_b = (_a = change.dimensions) === null || _a === void 0 ? void 0 : _a.width) !== null && _b !== void 0 ? _b : 0,
                                            "@_height": (_d = (_c = change.dimensions) === null || _c === void 0 ? void 0 : _c.height) !== null && _d !== void 0 ? _d : 0,
                                        },
                                    },
                                });
                            }
                        }
                        break;
                    case "position":
                        console.debug(`DMN DIAGRAM: 'onNodesChange' --> position '${change.id}'`);
                        state.dispatch(state).diagram.setNodeStatus(change.id, { dragging: change.dragging });
                        if (change.positionAbsolute) {
                            const node = state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(change.id);
                            const { delta } = repositionNode({
                                definitions: state.dmn.model.definitions,
                                drdIndex: state.computed(state).getDrdIndex(),
                                controlWaypointsByEdge,
                                change: {
                                    type: "absolute",
                                    nodeType: node.type,
                                    selectedEdges: [
                                        ...state.computed(state).getDiagramData(externalModelsByNamespace).selectedEdgesById.keys(),
                                    ],
                                    shapeIndex: node.data.shape.index,
                                    sourceEdgeIndexes: state
                                        .computed(state)
                                        .getDiagramData(externalModelsByNamespace)
                                        .edges.flatMap((e) => { var _a; return e.source === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                    targetEdgeIndexes: state
                                        .computed(state)
                                        .getDiagramData(externalModelsByNamespace)
                                        .edges.flatMap((e) => { var _a; return e.target === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                    position: change.positionAbsolute,
                                },
                            });
                            if (node.type === NODE_TYPES.decisionService && !((_e = node.data.shape["@_isCollapsed"]) !== null && _e !== void 0 ? _e : false)) {
                                const decisionService = node.data.dmnObject;
                                const { containedDecisionHrefsRelativeToThisDmn } = getDecisionServicePropertiesRelativeToThisDmn({
                                    thisDmnsNamespace: state.dmn.model.definitions["@_namespace"],
                                    decisionService,
                                    decisionServiceNamespace: (_f = node.data.dmnObjectNamespace) !== null && _f !== void 0 ? _f : state.dmn.model.definitions["@_namespace"],
                                });
                                for (let i = 0; i < containedDecisionHrefsRelativeToThisDmn.length; i++) {
                                    const diagramData = state.computed(state).getDiagramData(externalModelsByNamespace);
                                    const nestedNode = diagramData.nodesById.get(containedDecisionHrefsRelativeToThisDmn[i]);
                                    if (((_g = nestedNode === null || nestedNode === void 0 ? void 0 : nestedNode.data) === null || _g === void 0 ? void 0 : _g.shape) === undefined) {
                                        continue;
                                    }
                                    const snappedNestedNodeShapeWithAppliedDelta = snapShapePosition(state.diagram.snapGrid, offsetShapePosition(nestedNode.data.shape, delta));
                                    repositionNode({
                                        definitions: state.dmn.model.definitions,
                                        drdIndex: state.computed(state).getDrdIndex(),
                                        controlWaypointsByEdge,
                                        change: {
                                            type: "absolute",
                                            nodeType: nestedNode.type,
                                            selectedEdges: diagramData.edges.map((e) => e.id),
                                            shapeIndex: nestedNode.data.shape.index,
                                            sourceEdgeIndexes: diagramData.edges.flatMap((e) => { var _a; return e.source === nestedNode.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                            targetEdgeIndexes: diagramData.edges.flatMap((e) => { var _a; return e.target === nestedNode.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                            position: snappedNestedNodeShapeWithAppliedDelta,
                                        },
                                    });
                                }
                            }
                        }
                        break;
                    case "remove":
                        console.debug(`DMN DIAGRAM: 'onNodesChange' --> remove '${change.id}'`);
                        const node = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(change.id);
                        deleteNode({
                            definitions: state.dmn.model.definitions,
                            __readonly_drgEdges: state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges,
                            __readonly_drdIndex: state.computed(state).getDrdIndex(),
                            __readonly_dmnObjectNamespace: (_h = node.data.dmnObjectNamespace) !== null && _h !== void 0 ? _h : state.dmn.model.definitions["@_namespace"],
                            __readonly_dmnObjectQName: node.data.dmnObjectQName,
                            __readonly_dmnObjectId: (_j = node.data.dmnObject) === null || _j === void 0 ? void 0 : _j["@_id"],
                            __readonly_nodeNature: nodeNatures[node.type],
                            __readonly_mode: NodeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                            __readonly_externalDmnsIndex: state
                                .computed(state)
                                .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                            __readonly_externalModelsByNamespace: externalModelsByNamespace,
                        });
                        state.dispatch(state).diagram.setNodeStatus(node.id, {
                            selected: false,
                            dragging: false,
                            resizing: false,
                        });
                        break;
                    case "reset":
                        state.dispatch(state).diagram.setNodeStatus(change.item.id, {
                            selected: false,
                            dragging: false,
                            resizing: false,
                        });
                        break;
                    case "select":
                        state.dispatch(state).diagram.setNodeStatus(change.id, { selected: change.selected });
                        break;
                }
            }
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    const resetToBeforeEditingBegan = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            state.dmn.model = normalize(dmnModelBeforeEditingRef.current);
            state.diagram.draggingNodes = [];
            state.diagram.draggingWaypoints = [];
            state.diagram.resizingNodes = [];
            state.diagram.dropTargetNode = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi, dmnModelBeforeEditingRef]);
    const onNodeDrag = useCallback((e, node) => {
        nodeIdBeingDraggedRef.current = node.id;
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d, _e, _f;
            state.diagram.dropTargetNode = getFirstNodeFittingBounds(node.id, {
                "@_x": (_b = (_a = node.positionAbsolute) === null || _a === void 0 ? void 0 : _a.x) !== null && _b !== void 0 ? _b : 0,
                "@_y": (_d = (_c = node.positionAbsolute) === null || _c === void 0 ? void 0 : _c.y) !== null && _d !== void 0 ? _d : 0,
                "@_width": (_e = node.width) !== null && _e !== void 0 ? _e : 0,
                "@_height": (_f = node.height) !== null && _f !== void 0 ? _f : 0,
            }, MIN_NODE_SIZES[node.type], state.diagram.snapGrid);
        });
    }, [dmnEditorStoreApi, getFirstNodeFittingBounds]);
    const onNodeDragStart = useCallback((e, node, nodes) => {
        dmnModelBeforeEditingRef.current = thisDmn.model;
        onNodeDrag(e, node, nodes);
    }, [thisDmn.model, dmnModelBeforeEditingRef, onNodeDrag]);
    const onNodeDragStop = useCallback((e, node) => {
        try {
            dmnEditorStoreApi.setState((state) => {
                console.debug("DMN DIAGRAM: `onNodeDragStop`");
                const nodeBeingDragged = state
                    .computed(state)
                    .getDiagramData(externalModelsByNamespace)
                    .nodesById.get(nodeIdBeingDraggedRef.current);
                nodeIdBeingDraggedRef.current = null;
                if (!nodeBeingDragged) {
                    return;
                }
                const dropTargetNode = dmnEditorStoreApi.getState().diagram.dropTargetNode;
                if (dropTargetNode &&
                    containment.has(dropTargetNode.type) &&
                    !state.computed(state).isDropTargetNodeValidForSelection) {
                    console.debug(`DMN DIAGRAM: Invalid containment: '${[
                        ...state.computed(state).getDiagramData(externalModelsByNamespace).selectedNodeTypes,
                    ].join("', '")}' inside '${dropTargetNode.type}'. Ignoring nodes dropped.`);
                    resetToBeforeEditingBegan();
                    return;
                }
                const selectedNodes = [
                    ...state.computed(state).getDiagramData(externalModelsByNamespace).selectedNodesById.values(),
                ];
                state.diagram.dropTargetNode = undefined;
                if (!node.dragging) {
                    return;
                }
                if (nodeBeingDragged.data.parentRfNode) {
                    const p = state
                        .computed(state)
                        .getDiagramData(externalModelsByNamespace)
                        .nodesById.get(nodeBeingDragged.data.parentRfNode.id);
                    if ((p === null || p === void 0 ? void 0 : p.type) === NODE_TYPES.decisionService && nodeBeingDragged.type === NODE_TYPES.decision) {
                        for (let i = 0; i < selectedNodes.length; i++) {
                            deleteDecisionFromDecisionService({
                                definitions: state.dmn.model.definitions,
                                decisionHref: selectedNodes[i].id,
                                decisionServiceId: p.data.dmnObject["@_id"],
                                externalModelsByNamespace,
                            });
                        }
                    }
                    else {
                        console.debug(`DMN DIAGRAM: Ignoring '${nodeBeingDragged.type}' with parent '${dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type}' dropping somewhere..`);
                    }
                }
                if ((dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type) === NODE_TYPES.decisionService) {
                    for (let i = 0; i < selectedNodes.length; i++) {
                        addDecisionToDecisionService({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                            decisionHref: selectedNodes[i].id,
                            decisionServiceId: state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(dropTargetNode.id).data.dmnObject["@_id"],
                            snapGrid: state.diagram.snapGrid,
                            externalModelsByNamespace,
                        });
                    }
                }
                else {
                    console.debug(`DMN DIAGRAM: Ignoring '${nodeBeingDragged.type}' dropped on top of '${dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type}'`);
                }
            });
        }
        catch (e) {
            console.error(e);
            resetToBeforeEditingBegan();
        }
    }, [dmnEditorStoreApi, externalModelsByNamespace, resetToBeforeEditingBegan]);
    const onEdgesChange = useCallback((changes) => {
        dmnEditorStoreApi.setState((state) => {
            for (const change of changes) {
                switch (change.type) {
                    case "select":
                        console.debug(`DMN DIAGRAM: 'onEdgesChange' --> select '${change.id}'`);
                        state.dispatch(state).diagram.setEdgeStatus(change.id, { selected: change.selected });
                        break;
                    case "remove":
                        console.debug(`DMN DIAGRAM: 'onEdgesChange' --> remove '${change.id}'`);
                        const edge = state.computed(state).getDiagramData(externalModelsByNamespace).edgesById.get(change.id);
                        if (edge === null || edge === void 0 ? void 0 : edge.data) {
                            deleteEdge({
                                definitions: state.dmn.model.definitions,
                                drdIndex: state.computed(state).getDrdIndex(),
                                edge: { id: change.id, dmnObject: edge.data.dmnObject },
                                mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                                externalModelsByNamespace,
                            });
                            state.dispatch(state).diagram.setEdgeStatus(change.id, {
                                selected: false,
                                draggingWaypoint: false,
                            });
                        }
                        break;
                    case "add":
                    case "reset":
                        console.debug(`DMN DIAGRAM: 'onEdgesChange' --> add/reset '${change.item.id}'. Ignoring`);
                }
            }
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    const onEdgeUpdate = useCallback((oldEdge, newConnection) => {
        console.debug("DMN DIAGRAM: `onEdgeUpdate`", oldEdge, newConnection);
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d;
            const sourceNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(newConnection.source);
            const targetNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(newConnection.target);
            if (!sourceNode || !targetNode) {
                throw new Error("Cannot create connection without target and source nodes!");
            }
            const sourceBounds = sourceNode.data.shape["dc:Bounds"];
            const targetBounds = targetNode.data.shape["dc:Bounds"];
            if (!sourceBounds || !targetBounds) {
                throw new Error("Cannot create connection without target bounds!");
            }
            const lastWaypoint = ((_a = oldEdge.data) === null || _a === void 0 ? void 0 : _a.dmnEdge)
                ? oldEdge.data.dmnEdge["di:waypoint"][oldEdge.data.dmnEdge["di:waypoint"].length - 1]
                : getDmnBoundsCenterPoint(targetBounds);
            const firstWaypoint = ((_b = oldEdge.data) === null || _b === void 0 ? void 0 : _b.dmnEdge)
                ? oldEdge.data.dmnEdge["di:waypoint"][0]
                : getDmnBoundsCenterPoint(sourceBounds);
            const { newDmnEdge } = addEdge({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edge: {
                    autoPositionedEdgeMarker: undefined,
                    type: oldEdge.type,
                    targetHandle: ((_c = newConnection.targetHandle) !== null && _c !== void 0 ? _c : getHandlePosition({ shapeBounds: targetBounds, waypoint: lastWaypoint })
                        .handlePosition),
                    sourceHandle: ((_d = newConnection.sourceHandle) !== null && _d !== void 0 ? _d : getHandlePosition({ shapeBounds: sourceBounds, waypoint: firstWaypoint })
                        .handlePosition),
                },
                sourceNode: {
                    type: sourceNode.type,
                    href: sourceNode.id,
                    data: sourceNode.data,
                    bounds: sourceBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                targetNode: {
                    type: targetNode.type,
                    href: targetNode.id,
                    data: targetNode.data,
                    bounds: targetBounds,
                    index: targetNode.data.index,
                    shapeId: targetNode.data.shape["@_id"],
                },
                keepWaypoints: true,
                externalModelsByNamespace,
            });
            if (newDmnEdge["@_dmnElementRef"] !== oldEdge.id) {
                const { deletedDmnEdgeOnCurrentDrd } = deleteEdge({
                    definitions: state.dmn.model.definitions,
                    drdIndex: state.computed(state).getDrdIndex(),
                    edge: { id: oldEdge.id, dmnObject: oldEdge.data.dmnObject },
                    mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                    externalModelsByNamespace,
                });
                const deletedWaypoints = deletedDmnEdgeOnCurrentDrd === null || deletedDmnEdgeOnCurrentDrd === void 0 ? void 0 : deletedDmnEdgeOnCurrentDrd["di:waypoint"];
                if (oldEdge.source !== newConnection.source && deletedWaypoints) {
                    newDmnEdge["di:waypoint"] = [newDmnEdge["di:waypoint"][0], ...deletedWaypoints.slice(1)];
                }
                if (oldEdge.target !== newConnection.target && deletedWaypoints) {
                    newDmnEdge["di:waypoint"] = [
                        ...deletedWaypoints.slice(0, deletedWaypoints.length - 1),
                        newDmnEdge["di:waypoint"][newDmnEdge["di:waypoint"].length - 1],
                    ];
                }
            }
            state.diagram._selectedEdges = [newDmnEdge["@_dmnElementRef"]];
            state.diagram.ongoingConnection = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    const onEdgeUpdateStart = useCallback((e, edge, handleType) => {
        console.debug("DMN DIAGRAM: `onEdgeUpdateStart`");
        dmnEditorStoreApi.setState((state) => {
            state.diagram.edgeIdBeingUpdated = edge.id;
        });
    }, [dmnEditorStoreApi]);
    const onEdgeUpdateEnd = useCallback((e, edge, handleType) => {
        console.debug("DMN DIAGRAM: `onEdgeUpdateEnd`");
        dmnEditorStoreApi.setState((state) => {
            state.diagram.ongoingConnection = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi]);
    const handleRfKeyDownCapture = useCallback((e) => {
        const s = dmnEditorStoreApi.getState();
        if (e.key === "Escape") {
            if (s.computed(s).isDiagramEditingInProgress() && dmnModelBeforeEditingRef.current) {
                console.debug("DMN DIAGRAM: Intercepting Escape pressed and preventing propagation. Reverting DMN model to what it was before editing began.");
                e.stopPropagation();
                e.preventDefault();
                resetToBeforeEditingBegan();
            }
            else if (!s.diagram.ongoingConnection) {
                dmnEditorStoreApi.setState((state) => {
                    if (state.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size > 0 ||
                        state.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size > 0) {
                        console.debug("DMN DIAGRAM: Esc pressed. Desselecting everything.");
                        state.diagram._selectedNodes = [];
                        state.diagram._selectedEdges = [];
                        e.stopPropagation();
                        e.preventDefault();
                    }
                    else if (state.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size <= 0 &&
                        state.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size <= 0) {
                        console.debug("DMN DIAGRAM: Esc pressed. Closing all open panels.");
                        state.diagram.propertiesPanel.isOpen = false;
                        state.diagram.overlaysPanel.isOpen = false;
                        state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                        e.stopPropagation();
                        e.preventDefault();
                    }
                    else {
                    }
                });
            }
            else {
            }
        }
    }, [dmnEditorStoreApi, dmnModelBeforeEditingRef, externalModelsByNamespace, resetToBeforeEditingBegan]);
    const [showEmptyState, setShowEmptyState] = useState(true);
    const nodes = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).nodes);
    const edges = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).edges);
    const drgElementsWithoutVisualRepresentationOnCurrentDrdLength = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).drgElementsWithoutVisualRepresentationOnCurrentDrd
        .length);
    const isEmptyStateShowing = showEmptyState && nodes.length === 0 && drgElementsWithoutVisualRepresentationOnCurrentDrdLength === 0;
    const canAutoGenerateDrd = useDmnEditorStore((s) => s.diagram.autoLayout.canAutoGenerateDrd);
    const drdsLength = useDmnEditorStore((s) => { var _a, _b; return (_b = (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b.length; });
    const showAutoGenerateDrdModal = useMemo(() => {
        return canAutoGenerateDrd && drdsLength === undefined;
    }, [canAutoGenerateDrd, drdsLength]);
    return (_jsxs(_Fragment, { children: [showAutoGenerateDrdModal && _jsx(DmnDiagramWithoutDrd, {}), isEmptyStateShowing && !canAutoGenerateDrd && (_jsx(DmnDiagramEmptyState, { setShowEmptyState: setShowEmptyState, isReadOnly: settings.isReadOnly })), _jsxs(DiagramContainerContextProvider, { container: container, children: [_jsx("svg", { style: { position: "absolute", top: 0, left: 0 }, children: _jsx(EdgeMarkers, {}) }), _jsxs(RF.ReactFlow, { connectionMode: RF.ConnectionMode.Loose, onKeyDownCapture: handleRfKeyDownCapture, nodes: nodes, edges: edges, onNodesChange: onNodesChange, onEdgesChange: onEdgesChange, onEdgeUpdateStart: onEdgeUpdateStart, onEdgeUpdateEnd: onEdgeUpdateEnd, onEdgeUpdate: onEdgeUpdate, onlyRenderVisibleElements: true, zoomOnDoubleClick: false, elementsSelectable: true, panOnScroll: true, zoomOnScroll: false, preventScrolling: true, selectionOnDrag: true, panOnDrag: PAN_ON_DRAG, selectionMode: RF.SelectionMode.Full, isValidConnection: isValidConnection, connectionLineComponent: ConnectionLine, onConnect: onConnect, onConnectStart: onConnectStart, onConnectEnd: onConnectEnd, onNodeDragStart: onNodeDragStart, onNodeDrag: onNodeDrag, onNodeDragStop: onNodeDragStop, nodesDraggable: !settings.isReadOnly, nodeTypes: nodeTypes, edgeTypes: edgeTypes, snapToGrid: true, snapGrid: rfSnapGrid, defaultViewport: viewport, fitView: false, fitViewOptions: FIT_VIEW_OPTIONS, attributionPosition: "bottom-right", onInit: setReactFlowInstance, deleteKeyCode: settings.isReadOnly ? [] : DELETE_NODE_KEY_CODES, onDrop: onDrop, onDragOver: onDragOver, children: [_jsx(SelectionStatus, {}), _jsx(Palette, { pulse: isEmptyStateShowing }), _jsx(TopRightCornerPanels, { availableHeight: (_a = container.current) === null || _a === void 0 ? void 0 : _a.offsetHeight }), _jsx(DiagramCommands, {}), !isFirefox && _jsx(RF.Background, {}), _jsx(RF.Controls, { fitViewOptions: FIT_VIEW_OPTIONS, position: "bottom-right" }), _jsx(SetConnectionToReactFlowStore, {}), _jsx(ViewportWatcher, {})] })] })] }));
});
function DmnDiagramWithoutDrd() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { externalModelsByNamespace } = useExternalModels();
    return (_jsx(Bullseye, { style: {
            position: "absolute",
            width: "100%",
            pointerEvents: "none",
            zIndex: 1,
            height: "auto",
            marginTop: "120px",
        }, children: _jsxs("div", { className: "kie-dmn-editor--diagram-empty-state", children: [_jsx(Button, { title: "Close", style: {
                        position: "absolute",
                        top: "8px",
                        right: 0,
                    }, variant: ButtonVariant.plain, icon: _jsx(TimesIcon, {}), onClick: () => {
                        dmnEditorStoreApi.setState((s) => {
                            s.diagram.autoLayout.canAutoGenerateDrd = false;
                        });
                    } }), _jsxs(EmptyState, { variant: EmptyStateVariant.small, children: [_jsx(EmptyStateIcon, { icon: BlueprintIcon }), _jsx(Title, { size: "md", headingLevel: "h4", children: "Empty Diagram" }), _jsx(EmptyStateBody, { children: "The current DMN does not have any Diagram associated with it. Do you want to auto-generate it?" }), _jsx(EmptyStatePrimary, { children: _jsx(Button, { variant: ButtonVariant.link, isDisabled: settings.isReadOnly, icon: _jsx(OptimizeIcon, {}), onClick: async () => {
                                    const { computed, ...state } = dmnEditorStoreApi.getState();
                                    const dereferencedState = { computed, ...JSON.parse(JSON.stringify(state)) };
                                    const externalModelTypesByNamespace = dereferencedState
                                        .computed(dereferencedState)
                                        .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace);
                                    autoGenerateDrd({
                                        model: dereferencedState.dmn.model,
                                        diagram: dereferencedState.diagram,
                                        externalModelsByNamespace,
                                        externalModelTypesByNamespace,
                                    });
                                    const snapGrid = dereferencedState.diagram.snapGrid;
                                    const nodesById = dereferencedState
                                        .computed(dereferencedState)
                                        .getDiagramData(externalModelsByNamespace).nodesById;
                                    const edgesById = dereferencedState
                                        .computed(dereferencedState)
                                        .getDiagramData(externalModelsByNamespace).edgesById;
                                    const nodes = dereferencedState
                                        .computed(dereferencedState)
                                        .getDiagramData(externalModelsByNamespace).nodes;
                                    const edges = dereferencedState
                                        .computed(dereferencedState)
                                        .getDiagramData(externalModelsByNamespace).edges;
                                    const drgEdges = dereferencedState
                                        .computed(dereferencedState)
                                        .getDiagramData(externalModelsByNamespace).drgEdges;
                                    const isAlternativeInputDataShape = dereferencedState
                                        .computed(dereferencedState)
                                        .isAlternativeInputDataShape();
                                    const dmnShapesByHref = dereferencedState.computed(dereferencedState).indexedDrd().dmnShapesByHref;
                                    const { __readonly_autoLayoutedInfo, __readonly_parentNodesById } = await getAutoLayoutedInfo({
                                        __readonly_snapGrid: snapGrid,
                                        __readonly_nodesById: nodesById,
                                        __readonly_edgesById: edgesById,
                                        __readonly_nodes: nodes,
                                        __readonly_drgEdges: drgEdges,
                                        __readonly_isAlternativeInputDataShape: isAlternativeInputDataShape,
                                    });
                                    dmnEditorStoreApi.setState((s) => {
                                        s.diagram.autoLayout.canAutoGenerateDrd = false;
                                        applyAutoLayoutToDrd({
                                            state: dereferencedState,
                                            __readonly_dmnShapesByHref: dmnShapesByHref,
                                            __readonly_edges: edges,
                                            __readonly_edgesById: edgesById,
                                            __readonly_nodesById: nodesById,
                                            __readonly_autoLayoutedInfo,
                                            __readonly_parentNodesById,
                                            __readonly_drdIndex: dereferencedState.computed(dereferencedState).getDrdIndex(),
                                            __readonly_dmnObjectNamespace: dereferencedState.dmn.model.definitions["@_namespace"],
                                            __readonly_externalDmnsIndex: dereferencedState
                                                .computed(dereferencedState)
                                                .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                                            __readonly_externalModelsByNamespace: externalModelsByNamespace,
                                        });
                                        s.dmn.model = dereferencedState.dmn.model;
                                    });
                                }, children: "Auto-generate Diagram" }) }), _jsx("br", {}), _jsx(EmptyStateBody, { style: { fontSize: "12px", wordBreak: "break-word" }, children: "Auto generating the diagram will automatically place the nodes with the default size and shape. You can also manually build your diagram using the \"DRG Nodes\" option from the palette." })] })] }) }));
}
function DmnDiagramEmptyState({ setShowEmptyState, isReadOnly, }) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const externalDmnModelsByNamespaceMap = useDmnEditorStore((s) => s.computed(s).getExternalDmnModelsByNamespaceMap(externalModelsByNamespace));
    return (_jsx(Bullseye, { style: {
            position: "absolute",
            width: "100%",
            pointerEvents: "none",
            zIndex: 1,
            height: "auto",
            marginTop: "120px",
        }, children: _jsxs("div", { className: "kie-dmn-editor--diagram-empty-state", children: [_jsx(Button, { title: "Close", style: {
                        position: "absolute",
                        top: "8px",
                        right: 0,
                    }, variant: ButtonVariant.plain, icon: _jsx(TimesIcon, {}), onClick: () => setShowEmptyState(false) }), _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: MousePointerIcon }), _jsx(Title, { size: "md", headingLevel: "h4", children: `This DMN's Diagram is empty` }), isReadOnly ? (_jsx(_Fragment, { children: _jsx(EmptyStateBody, { children: "Make sure the DMN has nodes or try opening another file" }) })) : (_jsxs(_Fragment, { children: [_jsx(EmptyStateBody, { children: "Start by dragging nodes from the Palette" }), _jsx("br", {}), _jsx(EmptyStateBody, { children: "or" }), _jsxs(EmptyStatePrimary, { children: [_jsx(Button, { variant: ButtonVariant.link, icon: _jsx(TableIcon, {}), onClick: () => {
                                                dmnEditorStoreApi.setState((state) => {
                                                    var _a;
                                                    const { href: decisionNodeHref } = addStandaloneNode({
                                                        definitions: state.dmn.model.definitions,
                                                        drdIndex: state.computed(state).getDrdIndex(),
                                                        newNode: {
                                                            type: NODE_TYPES.decision,
                                                            bounds: {
                                                                "@_x": 100,
                                                                "@_y": 100,
                                                                "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                                    snapGrid: state.diagram.snapGrid,
                                                                })["@_width"],
                                                                "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                                    snapGrid: state.diagram.snapGrid,
                                                                })["@_height"],
                                                            },
                                                        },
                                                        externalModelsByNamespace,
                                                    });
                                                    const drgElementIndex = ((_a = state.dmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).length - 1;
                                                    const defaultWidthsById = new Map();
                                                    const defaultExpression = getDefaultBoxedExpression({
                                                        logicType: "decisionTable",
                                                        allTopLevelDataTypesByFeelName: new Map(),
                                                        typeRef: undefined,
                                                        getDefaultColumnWidth,
                                                        widthsById: defaultWidthsById,
                                                    });
                                                    updateExpression({
                                                        definitions: state.dmn.model.definitions,
                                                        drgElementIndex,
                                                        expression: {
                                                            ...defaultExpression,
                                                            "@_label": "New Decision",
                                                        },
                                                        externalDmnModelsByNamespaceMap,
                                                    });
                                                    updateExpressionWidths({
                                                        definitions: state.dmn.model.definitions,
                                                        drdIndex: state.computed(state).getDrdIndex(),
                                                        widthsById: defaultWidthsById,
                                                    });
                                                    state.dispatch(state).boxedExpressionEditor.open(parseXmlHref(decisionNodeHref).id);
                                                });
                                            }, children: "New Decision Table..." }), _jsx("br", {}), _jsx(Button, { variant: ButtonVariant.link, icon: _jsx(BlueprintIcon, {}), onClick: () => {
                                                dmnEditorStoreApi.setState((state) => {
                                                    const inputDataNodeBounds = {
                                                        "@_x": 100,
                                                        "@_y": 300,
                                                        "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.inputData]({
                                                            snapGrid: state.diagram.snapGrid,
                                                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                                        })["@_width"],
                                                        "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.inputData]({
                                                            snapGrid: state.diagram.snapGrid,
                                                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                                        })["@_height"],
                                                    };
                                                    const { href: inputDataNodeHref, shapeId: inputDataShapeId } = addStandaloneNode({
                                                        definitions: state.dmn.model.definitions,
                                                        drdIndex: state.computed(state).getDrdIndex(),
                                                        newNode: {
                                                            type: NODE_TYPES.inputData,
                                                            bounds: inputDataNodeBounds,
                                                        },
                                                        externalModelsByNamespace,
                                                    });
                                                    const { href: decisionNodeHref } = addConnectedNode({
                                                        definitions: state.dmn.model.definitions,
                                                        drdIndex: state.computed(state).getDrdIndex(),
                                                        edgeType: EDGE_TYPES.informationRequirement,
                                                        sourceNode: {
                                                            href: inputDataNodeHref,
                                                            type: NODE_TYPES.inputData,
                                                            bounds: inputDataNodeBounds,
                                                            shapeId: inputDataShapeId,
                                                        },
                                                        newNode: {
                                                            type: NODE_TYPES.decision,
                                                            bounds: {
                                                                "@_x": 100,
                                                                "@_y": 100,
                                                                "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                                    snapGrid: state.diagram.snapGrid,
                                                                })["@_width"],
                                                                "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                                    snapGrid: state.diagram.snapGrid,
                                                                })["@_height"],
                                                            },
                                                        },
                                                        externalModelsByNamespace,
                                                    });
                                                    state.diagram._selectedNodes = [decisionNodeHref];
                                                    state.diagram.propertiesPanel.isOpen = true;
                                                });
                                            }, children: "New Decision with Input Data..." })] })] }))] })] }) }));
}
export function ViewportWatcher() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    useOnViewportChange({
        onChange: (viewport) => {
            dmnEditorStoreApi.setState((state) => {
                state.diagram.viewport = {
                    x: viewport.x,
                    y: viewport.y,
                    zoom: viewport.zoom,
                };
            });
        },
    });
    return _jsx(_Fragment, {});
}
export function SetConnectionToReactFlowStore(props) {
    const ongoingConnection = useDmnEditorStore((s) => s.diagram.ongoingConnection);
    const rfStoreApi = RF.useStoreApi();
    useEffect(() => {
        rfStoreApi.setState({
            connectionHandleId: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleId,
            connectionHandleType: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleType,
            connectionNodeId: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.nodeId,
        });
    }, [ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleId, ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleType, ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.nodeId, rfStoreApi]);
    return _jsx(_Fragment, {});
}
export function TopRightCornerPanels({ availableHeight }) {
    const diagram = useDmnEditorStore((s) => s.diagram);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const togglePropertiesPanel = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            state.diagram.propertiesPanel.isOpen = !state.diagram.propertiesPanel.isOpen;
        });
    }, [dmnEditorStoreApi]);
    const toggleOverlaysPanel = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            state.diagram.overlaysPanel.isOpen = !state.diagram.overlaysPanel.isOpen;
        });
    }, [dmnEditorStoreApi]);
    useLayoutEffect(() => {
        dmnEditorStoreApi.setState((state) => {
            if (state.diagram.overlaysPanel.isOpen) {
                setTimeout(() => {
                    dmnEditorStoreApi.setState((state) => {
                        state.diagram.overlaysPanel.isOpen = true;
                    });
                }, 300);
            }
            state.diagram.overlaysPanel.isOpen = false;
        });
    }, [dmnEditorStoreApi, diagram.propertiesPanel.isOpen]);
    return (_jsx(_Fragment, { children: _jsx(RF.Panel, { position: "top-right", children: _jsxs(Flex, { children: [diagram.overlays.enableEvaluationHighlights && _jsx(EvaluationHighlightsBadge, {}), !settings.isReadOnly && (_jsx("aside", { className: "kie-dmn-editor--autolayout-panel-toggle", children: _jsx(AutolayoutButton, {}) })), _jsx("aside", { className: "kie-dmn-editor--overlays-panel-toggle", children: _jsx(Popover, { className: "kie-dmn-editor--overlay-panel-popover", "aria-label": "Overlays Panel", position: "bottom-end", enableFlip: false, flipBehavior: ["bottom-end"], hideOnOutsideClick: false, showClose: false, isVisible: diagram.overlaysPanel.isOpen, bodyContent: _jsx(OverlaysPanel, { availableHeight: (availableHeight !== null && availableHeight !== void 0 ? availableHeight : 0) - AREA_ABOVE_OVERLAYS_PANEL }), children: _jsx("button", { className: "kie-dmn-editor--overlays-panel-toggle-button", onClick: toggleOverlaysPanel, title: "Overlays", children: _jsx(VirtualMachineIcon, { size: "sm" }) }) }, `${diagram.overlaysPanel.isOpen}`) }), !diagram.propertiesPanel.isOpen && (_jsx("aside", { className: "kie-dmn-editor--properties-panel-toggle", children: _jsx("button", { className: "kie-dmn-editor--properties-panel-toggle-button", onClick: togglePropertiesPanel, title: "Properties panel", children: _jsx(InfoIcon, { size: "sm" }) }) }))] }) }) }));
}
export function SelectionStatus() {
    const rfStoreApi = RF.useStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const selectedNodesCount = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size);
    const selectedEdgesCount = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    useEffect(() => {
        if (selectedNodesCount >= 2) {
            rfStoreApi.setState({ nodesSelectionActive: true });
        }
    }, [rfStoreApi, selectedNodesCount]);
    const onClose = useCallback((e) => {
        e.stopPropagation();
        dmnEditorStoreApi.setState((state) => {
            state.diagram._selectedNodes = [];
            state.diagram._selectedEdges = [];
        });
    }, [dmnEditorStoreApi]);
    return (_jsx(_Fragment, { children: (selectedNodesCount + selectedEdgesCount >= 2 && (_jsx(RF.Panel, { position: "top-center", children: _jsx(Label, { style: { paddingLeft: "24px" }, onClose: onClose, children: (selectedEdgesCount === 0 && `${selectedNodesCount} nodes selected`) ||
                    (selectedNodesCount === 0 && `${selectedEdgesCount} edges selected`) ||
                    `${selectedNodesCount} node${selectedNodesCount === 1 ? "" : "s"}, ${selectedEdgesCount} edge${selectedEdgesCount === 1 ? "" : "s"} selected` }) }))) || _jsx(_Fragment, {}) }));
}
//# sourceMappingURL=Diagram.js.map