import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Select, SelectGroup, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { useCallback, useRef, useState } from "react";
import { TypeRefLabel } from "./TypeRefLabel";
import { ArrowUpIcon } from "@patternfly/react-icons/dist/js/icons/arrow-up-icon";
import { DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { builtInFeelTypeNames, builtInFeelTypes } from "./BuiltInFeelTypes";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function TypeRefSelector({ zoom, heightRef, onChange, typeRef, isDisabled, menuAppendTo, onCreate, onToggle, removeDataTypes, }) {
    const [isOpen, setOpen] = useState(false);
    const { externalModelsByNamespace } = useExternalModels();
    const selectedDataType = useDmnEditorStore((s) => typeRef
        ? s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName.get(typeRef)
        : undefined);
    const _onToggle = useCallback((isExpanded) => {
        onToggle === null || onToggle === void 0 ? void 0 : onToggle(isExpanded);
        setOpen(isExpanded);
    }, [onToggle]);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { customDataTypes, externalDataTypes } = useDmnEditorStore((state) => {
        const customDataTypes = [];
        const externalDataTypes = [];
        [...state.computed(state).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName.values()].forEach((s) => {
            if (s.parentId) {
                return;
            }
            if (s.namespace === state.dmn.model.definitions["@_namespace"]) {
                if ((removeDataTypes !== null && removeDataTypes !== void 0 ? removeDataTypes : []).findIndex((removeDataType) => removeDataType.feelName === s.feelName) < 0) {
                    customDataTypes.push(s);
                }
            }
            else {
                externalDataTypes.push(s);
            }
        });
        return { customDataTypes, externalDataTypes };
    });
    const exists = selectedDataType || (typeRef && builtInFeelTypeNames.has(typeRef));
    const id = generateUuid();
    const toggleRef = useRef(null);
    const { maxHeight, direction } = useInViewSelect(heightRef !== null && heightRef !== void 0 ? heightRef : { current: document.body }, toggleRef, zoom !== null && zoom !== void 0 ? zoom : 1);
    return (_jsxs(Flex, { id: id, justifyContent: { default: "justifyContentFlexStart" }, flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" }, children: [(selectedDataType === null || selectedDataType === void 0 ? void 0 : selectedDataType.itemDefinition) && (_jsx(Button, { title: "Jump to definition", className: "kie-dmn-editor--data-type-jump-to-definition", variant: ButtonVariant.control, onClick: (e) => dmnEditorStoreApi.setState((state) => {
                    var _a;
                    state.navigation.tab = DmnEditorTab.DATA_TYPES;
                    state.dataTypesEditor.activeItemDefinitionId = (_a = selectedDataType === null || selectedDataType === void 0 ? void 0 : selectedDataType.itemDefinition) === null || _a === void 0 ? void 0 : _a["@_id"];
                }), children: _jsx(ArrowUpIcon, {}) })), _jsxs(Select, { toggleRef: toggleRef, className: !exists && typeRef ? "kie-dmn-editor--type-ref-selector-invalid-value" : undefined, isDisabled: isDisabled, variant: SelectVariant.typeahead, typeAheadAriaLabel: DmnBuiltInDataType.Undefined, onToggle: _onToggle, onSelect: (e, v) => {
                    _onToggle(false);
                    onChange(v === DmnBuiltInDataType.Undefined ? undefined : v);
                }, selections: typeRef !== null && typeRef !== void 0 ? typeRef : DmnBuiltInDataType.Undefined, isOpen: isOpen, "aria-labelledby": "Data types selector", placeholderText: "Select a data type...", isCreatable: !!onCreate, isCreateOptionOnTop: false, onCreateOption: onCreate, isGrouped: true, menuAppendTo: menuAppendTo !== null && menuAppendTo !== void 0 ? menuAppendTo : document.body, maxHeight: maxHeight, direction: direction, onWheelCapture: (e) => e.stopPropagation(), children: [_jsx(SelectGroup, { label: "Built-in", style: { minWidth: "300px" }, children: builtInFeelTypes.map((dt) => (_jsx(SelectOption, { value: dt.name, children: dt.name }, dt.name))) }, "builtin"), _jsx(SelectGroup, { label: "Custom", style: { minWidth: "300px" }, children: (customDataTypes.length > 0 &&
                            customDataTypes.map((dt) => {
                                var _a, _b;
                                return (_jsxs(SelectOption, { value: dt.feelName, children: [dt.feelName, "\u00A0", _jsx(TypeRefLabel, { typeRef: (_a = dt.itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text, relativeToNamespace: dt.namespace, isCollection: (_b = dt.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_isCollection"] })] }, dt.feelName));
                            })) || _jsx(SelectOption, { value: "None", isDisabled: true }, "None") }, "custom"), _jsx(SelectGroup, { label: "External", style: { minWidth: "300px" }, children: (externalDataTypes.length > 0 &&
                            externalDataTypes.map((dt) => {
                                var _a, _b;
                                return (_jsxs(SelectOption, { value: dt.feelName, children: [dt.feelName, "\u00A0", _jsx(TypeRefLabel, { typeRef: (_a = dt.itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text, relativeToNamespace: dt.namespace, isCollection: (_b = dt.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_isCollection"] })] }, dt.feelName));
                            })) || _jsx(SelectOption, { value: "None", isDisabled: true }, "None") }, "external")] })] }));
}
//# sourceMappingURL=TypeRefSelector.js.map