import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { CopyIcon } from "@patternfly/react-icons/dist/js/icons/copy-icon";
import { CutIcon } from "@patternfly/react-icons/dist/js/icons/cut-icon";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { TypeRefSelector } from "./TypeRefSelector";
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { ImportIcon } from "@patternfly/react-icons/dist/js/icons/import-icon";
import { AngleDownIcon } from "@patternfly/react-icons/dist/js/icons/angle-down-icon";
import { AngleRightIcon } from "@patternfly/react-icons/dist/js/icons/angle-right-icon";
import { EyeIcon } from "@patternfly/react-icons/dist/js/icons/eye-icon";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { DataTypeName } from "./DataTypeName";
import { canHaveConstraints, getNewItemDefinition, isStruct } from "./DataTypeSpec";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { buildClipboardFromDataType, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE, getClipboard, } from "../clipboard/Clipboard";
import { getNewDmnIdRandomizer } from "@kie-tools/dmn-marshaller/dist/idRandomizer/dmnIdRandomizer";
import { isEnum } from "./ConstraintsEnum";
import { isRange } from "./ConstraintsRange";
import { constraintTypeHelper, recursivelyGetRootItemDefinition } from "./Constraints";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
import { useDmnEditor } from "../DmnEditorContext";
import { resolveTypeRef } from "./resolveTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export const BRIGHTNESS_DECREASE_STEP_IN_PERCENTAGE_PER_NESTING_LEVEL = 5;
export const STARTING_BRIGHTNESS_LEVEL_IN_PERCENTAGE = 95;
const addItemComponentButtonWidthInPxs = 24;
const expandButtonWidthInPxs = 24;
const expandButtonoHorizontalMarginInPxs = 12;
const leftGutterForStructsInPxs = addItemComponentButtonWidthInPxs + expandButtonWidthInPxs + expandButtonoHorizontalMarginInPxs * 2;
const rowPaddingRight = 16;
export function ItemComponentsTable({ isReadOnly, parent, editItemDefinition, addItemComponent, dropdownOpenFor, allDataTypesById, setDropdownOpenFor, }) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const expandedItemComponentIds = useDmnEditorStore((s) => s.dataTypesEditor.expandedItemComponentIds);
    const allTopLevelDataTypesByFeelName = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName);
    const allTopLevelItemDefinitionUniqueNames = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames);
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const expandedItemComponentIdsSet = useMemo(() => {
        return new Set(expandedItemComponentIds);
    }, [expandedItemComponentIds]);
    const dataTypes = parent.children;
    const flatTree = useMemo(() => {
        var _a;
        const ret = [];
        function traverse(dataType, allUniqueNamesAtLevel) {
            var _a, _b, _c;
            for (let i = 0; i < ((_a = dataType === null || dataType === void 0 ? void 0 : dataType.length) !== null && _a !== void 0 ? _a : 0); i++) {
                ret.push({ dataType: dataType[i], allUniqueNamesAtLevel });
                traverse((_b = dataType[i].children) !== null && _b !== void 0 ? _b : [], ((_c = dataType[i].itemDefinition.itemComponent) !== null && _c !== void 0 ? _c : []).reduce((acc, s) => acc.set(s["@_name"], s["@_id"]), new Map([...builtInFeelTypeNames].map((s) => [s, s]))));
            }
        }
        traverse(dataTypes !== null && dataTypes !== void 0 ? dataTypes : [], ((_a = parent.itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : []).reduce((acc, s) => acc.set(s["@_name"], s["@_id"]), new Map([...builtInFeelTypeNames].map((s) => [s, s]))));
        return ret;
    }, [dataTypes, parent.itemDefinition.itemComponent]);
    const expandAll = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            state.dataTypesEditor.expandedItemComponentIds = flatTree.flatMap((s) => isStruct(s.dataType.itemDefinition) ? s.dataType.itemDefinition["@_id"] : []);
        });
    }, [dmnEditorStoreApi, flatTree]);
    const collapseAll = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            state.dataTypesEditor.expandedItemComponentIds = [];
        });
    }, [dmnEditorStoreApi]);
    const { dmnEditorRootElementRef } = useDmnEditor();
    return (_jsxs(_Fragment, { children: [_jsxs(Flex, { justifyContent: { default: "justifyContentSpaceBetween" }, children: [_jsx(FlexItem, { children: _jsxs(Title, { size: "md", headingLevel: "h4", children: [`Properties in '${parent.itemDefinition["@_name"]}'`, !isReadOnly && (_jsx(Button, { title: "Add item component (at the top)", variant: ButtonVariant.link, onClick: () => addItemComponent(parent.itemDefinition["@_id"], "unshift", {
                                        "@_name": "New property",
                                        typeRef: undefined,
                                    }), children: _jsx(PlusCircleIcon, {}) }))] }) }), _jsxs(FlexItem, { children: [_jsx(Button, { variant: ButtonVariant.link, onClick: expandAll, children: "Expand all" }), _jsx(Button, { variant: ButtonVariant.link, onClick: collapseAll, children: "Collapse all" }), !isReadOnly && (_jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-properties-table", onToggle: (isOpen) => setDropdownOpenFor(isOpen ? parent.itemDefinition["@_id"] : undefined) }), onSelect: () => setDropdownOpenFor(undefined), isOpen: dropdownOpenFor === parent.itemDefinition["@_id"], menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                    _jsx(DropdownItem, { style: { minWidth: "240px" }, icon: _jsx(PasteIcon, {}), onClick: () => {
                                            navigator.clipboard.readText().then((text) => {
                                                const clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
                                                if (!clipboard) {
                                                    return;
                                                }
                                                getNewDmnIdRandomizer()
                                                    .ack({
                                                    json: clipboard.itemDefinitions,
                                                    type: "DMN15__tDefinitions",
                                                    attr: "itemDefinition",
                                                })
                                                    .randomize();
                                                for (const itemDefinition of clipboard.itemDefinitions) {
                                                    addItemComponent(parent.itemDefinition["@_id"], "unshift", itemDefinition);
                                                }
                                            });
                                        }, children: "Paste property" }, "paste-property"),
                                ] }))] })] }), flatTree.length <= 0 && (_jsx("div", { className: "kie-dmn-editor--data-type-properties-table--empty-state", children: isReadOnly ? "None" : "None yet" })), flatTree.length > 0 && (_jsxs("table", { className: "kie-dmn-editor--data-type-properties-table", children: [_jsx("thead", { children: _jsxs("tr", { children: [_jsx("th", { style: { minWidth: "200px", width: "67%" }, children: "Name" }), _jsx("th", { style: { minWidth: "140px", maxWidth: "140px" }, children: "Is struct?" }), _jsx("th", { style: { minWidth: "280px", width: "33%" }, children: "Type" }), _jsx("th", { style: { minWidth: "140px", maxWidth: "140px" }, children: "Is collection?" }), _jsx("th", { style: { minWidth: "200px", maxWidth: "200px" }, children: "Constraints" }), _jsx("th", {})] }) }), _jsx("tbody", { children: flatTree.map(({ dataType: dt, allUniqueNamesAtLevel }, i) => {
                            var _a, _b, _c, _d;
                            const nextDt = flatTree[Math.min(i + 1, flatTree.length - 1)].dataType;
                            const lastDt = flatTree[Math.max(i - 1, 0)].dataType;
                            const nextIsUpper = nextDt.parents.size < dt.parents.size;
                            const lastIsUpper = lastDt.parents.size < dt.parents.size;
                            let areAllParentsExpanded = true;
                            for (const p of [...dt.parents].reverse()) {
                                if (p === parent.itemDefinition["@_id"]) {
                                    break;
                                }
                                else if (!expandedItemComponentIdsSet.has(p)) {
                                    areAllParentsExpanded = false;
                                }
                            }
                            const shouldShowRow = dt.parentId === parent.itemDefinition["@_id"] ||
                                (isStruct(allDataTypesById.get(dt.parentId).itemDefinition) && areAllParentsExpanded);
                            const level = dt.parents.size - parent.parents.size - 1;
                            const brigthnessPercentage = STARTING_BRIGHTNESS_LEVEL_IN_PERCENTAGE -
                                level * BRIGHTNESS_DECREASE_STEP_IN_PERCENTAGE_PER_NESTING_LEVEL;
                            const constraintLabel = () => {
                                var _a, _b, _c, _d, _e, _f, _g, _h, _j;
                                if (((_a = dt.itemDefinition.typeConstraint) === null || _a === void 0 ? void 0 : _a["@_kie:constraintType"]) === "enumeration" ||
                                    ((_b = dt.itemDefinition.allowedValues) === null || _b === void 0 ? void 0 : _b["@_kie:constraintType"]) === "enumeration") {
                                    return _jsx(_Fragment, { children: "Enumeration" });
                                }
                                if (((_c = dt.itemDefinition.typeConstraint) === null || _c === void 0 ? void 0 : _c["@_kie:constraintType"]) === "expression" ||
                                    ((_d = dt.itemDefinition.allowedValues) === null || _d === void 0 ? void 0 : _d["@_kie:constraintType"]) === "expression") {
                                    return _jsx(_Fragment, { children: "Expression" });
                                }
                                if (((_e = dt.itemDefinition.typeConstraint) === null || _e === void 0 ? void 0 : _e["@_kie:constraintType"]) === "range" ||
                                    ((_f = dt.itemDefinition.allowedValues) === null || _f === void 0 ? void 0 : _f["@_kie:constraintType"]) === "range") {
                                    return _jsx(_Fragment, { children: "Range" });
                                }
                                const constraintValue = (_h = (_g = dt.itemDefinition.typeConstraint) === null || _g === void 0 ? void 0 : _g.text.__$$text) !== null && _h !== void 0 ? _h : (_j = dt.itemDefinition.allowedValues) === null || _j === void 0 ? void 0 : _j.text.__$$text;
                                const typeHelper = constraintTypeHelper(dt.itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames);
                                if (constraintValue === undefined) {
                                    return _jsx(_Fragment, { children: "None" });
                                }
                                if (isEnum(constraintValue, typeHelper.check)) {
                                    return _jsx(_Fragment, { children: "Enumeration" });
                                }
                                if (isRange(constraintValue, typeHelper.check)) {
                                    return _jsx(_Fragment, { children: "Range" });
                                }
                                return _jsx(_Fragment, { children: "Expression" });
                            };
                            const rootItemDefinition = recursivelyGetRootItemDefinition(dt.itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames);
                            const isItemComponent = !!((_b = (_a = parent.itemDefinition) === null || _a === void 0 ? void 0 : _a.itemComponent) === null || _b === void 0 ? void 0 : _b.find((ic) => ic["@_id"] === rootItemDefinition["@_id"]));
                            return (_jsx(React.Fragment, { children: shouldShowRow && (_jsxs("tr", { style: { backdropFilter: `brightness(${brigthnessPercentage}%)` }, className: `${nextIsUpper ? "last-nested-at-level" : ""} ${lastIsUpper ? "first-nested-at-level" : ""}`, children: [_jsx("td", { style: {
                                                paddingLeft: `${rowPaddingRight + level * leftGutterForStructsInPxs}px`,
                                            }, children: _jsxs("div", { style: { display: "flex" }, children: [_jsx("div", { style: {
                                                            width: `${expandButtonWidthInPxs}px`,
                                                            margin: `0 ${expandButtonoHorizontalMarginInPxs}px`,
                                                        }, children: isStruct(dt.itemDefinition) && (_jsx(Button, { title: "Expand / collapse item component", variant: ButtonVariant.link, style: { padding: "0 8px 0 0" }, onClick: (e) => dmnEditorStoreApi.setState((state) => {
                                                                if (expandedItemComponentIdsSet.has(dt.itemDefinition["@_id"])) {
                                                                    state.dataTypesEditor.expandedItemComponentIds =
                                                                        state.dataTypesEditor.expandedItemComponentIds.filter((s) => s !== dt.itemDefinition["@_id"]);
                                                                }
                                                                else {
                                                                    state.dataTypesEditor.expandedItemComponentIds.push(dt.itemDefinition["@_id"]);
                                                                }
                                                            }), children: (expandedItemComponentIdsSet.has(dt.itemDefinition["@_id"]) && _jsx(AngleDownIcon, {})) || (_jsx(AngleRightIcon, {})) })) }), _jsx("div", { style: { width: `${addItemComponentButtonWidthInPxs}px` }, children: !isReadOnly && isStruct(dt.itemDefinition) && (_jsx(Button, { title: "Add item component", variant: ButtonVariant.link, style: { padding: "0 8px 0 0" }, onClick: () => {
                                                                addItemComponent(dt.itemDefinition["@_id"], "unshift", {
                                                                    "@_name": "New property",
                                                                    typeRef: undefined,
                                                                });
                                                                dmnEditorStoreApi.setState((state) => {
                                                                    state.dataTypesEditor.expandedItemComponentIds.push(dt.itemDefinition["@_id"]);
                                                                });
                                                            }, children: _jsx(PlusCircleIcon, {}) })) }), _jsx("div", { style: { flexGrow: 1 }, children: _jsx(DataTypeName, { relativeToNamespace: dt.namespace, editMode: "hover", isActive: false, itemDefinition: dt.itemDefinition, isReadOnly: isReadOnly || dt.namespace !== thisDmnsNamespace, onGetAllUniqueNames: () => allUniqueNamesAtLevel }) })] }) }), _jsx("td", { children: _jsx(Switch, { "aria-label": "Is struct?", isDisabled: isReadOnly, isChecked: isStruct(dt.itemDefinition), onChange: (isChecked) => {
                                                    editItemDefinition(dt.itemDefinition["@_id"], (itemDefinition, items) => {
                                                        if (isChecked) {
                                                            itemDefinition.typeRef = undefined;
                                                            itemDefinition.itemComponent = [];
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                        else {
                                                            itemDefinition.typeRef = { __$$text: DmnBuiltInDataType.Any };
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                    });
                                                } }) }), _jsx("td", { children: !isStruct(dt.itemDefinition) && (_jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, isDisabled: isReadOnly, typeRef: resolveTypeRef({
                                                    typeRef: (_c = dt.itemDefinition.typeRef) === null || _c === void 0 ? void 0 : _c.__$$text,
                                                    namespace: parent.namespace,
                                                    allTopLevelDataTypesByFeelName,
                                                    externalModelsByNamespace,
                                                    thisDmnsImportsByNamespace: importsByNamespace,
                                                    relativeToNamespace: thisDmnsNamespace,
                                                }), onChange: (newDataType) => {
                                                    editItemDefinition(dt.itemDefinition["@_id"], (itemDefinition, items) => {
                                                        var _a;
                                                        if (((_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== newDataType) {
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                        itemDefinition.typeRef = newDataType ? { __$$text: newDataType } : undefined;
                                                    });
                                                } })) }), _jsx("td", { children: _jsx(Switch, { "aria-label": "Is collection?", isDisabled: isReadOnly, isChecked: (_d = dt.itemDefinition["@_isCollection"]) !== null && _d !== void 0 ? _d : false, onChange: (isChecked) => {
                                                    editItemDefinition(dt.itemDefinition["@_id"], (itemDefinition, items) => {
                                                        itemDefinition["@_isCollection"] = isChecked;
                                                        itemDefinition.typeConstraint = undefined;
                                                        itemDefinition.allowedValues = undefined;
                                                    });
                                                } }) }), _jsx("td", { children: canHaveConstraints(rootItemDefinition) ||
                                                (isStruct(rootItemDefinition) && !isItemComponent) ? (_jsx(Button, { variant: ButtonVariant.link, onClick: () => {
                                                    dmnEditorStoreApi.setState((state) => {
                                                        state.dataTypesEditor.activeItemDefinitionId = dt.itemDefinition["@_id"];
                                                    });
                                                }, children: constraintLabel() })) : (_jsx("p", { style: { paddingLeft: "16px", paddingRight: "16px" }, children: "-" })) }), _jsx("td", { children: _jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-" + dt.itemDefinition["@_id"], onToggle: (isOpen) => setDropdownOpenFor(isOpen ? dt.itemDefinition["@_id"] : undefined) }), onSelect: () => setDropdownOpenFor(undefined), isOpen: dropdownOpenFor === dt.itemDefinition["@_id"], menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                                    _jsx(DropdownItem, { icon: _jsx(EyeIcon, {}), onClick: () => {
                                                            dmnEditorStoreApi.setState((state) => {
                                                                state.dataTypesEditor.activeItemDefinitionId = dt.itemDefinition["@_id"];
                                                            });
                                                        }, children: "View" }, "view-type"),
                                                    _jsx(DropdownSeparator, {}, "view-separator"),
                                                    _jsx(React.Fragment, { children: !isReadOnly && (_jsxs(_Fragment, { children: [_jsx(DropdownItem, { icon: _jsx(ImportIcon, { style: { transform: "scale(-1, -1)" } }), style: { minWidth: "240px" }, onClick: () => {
                                                                        editItemDefinition(dt.itemDefinition["@_id"], (itemDefinition, _, __, itemDefinitions) => {
                                                                            const newItemDefinition = getNewItemDefinition({
                                                                                ...dt.itemDefinition,
                                                                                typeRef: dt.itemDefinition.typeRef,
                                                                                "@_name": `t${dt.itemDefinition["@_name"]}`,
                                                                                "@_isCollection": false,
                                                                            });
                                                                            const newItemDefinitionCopy = JSON.parse(JSON.stringify(newItemDefinition));
                                                                            getNewDmnIdRandomizer()
                                                                                .ack({
                                                                                json: [newItemDefinitionCopy],
                                                                                type: "DMN15__tDefinitions",
                                                                                attr: "itemDefinition",
                                                                            })
                                                                                .randomize();
                                                                            itemDefinitions.unshift(newItemDefinitionCopy);
                                                                            if (!isReadOnly) {
                                                                                itemDefinition["@_id"] = generateUuid();
                                                                                itemDefinition.typeRef = { __$$text: newItemDefinitionCopy["@_name"] };
                                                                                itemDefinition.itemComponent = undefined;
                                                                            }
                                                                        });
                                                                    }, children: "Extract data type" }, "extract-to-top-level"), _jsx(DropdownSeparator, {}, "extract-data-type-separator")] })) }, "extract-to-top-level-fragment"),
                                                    _jsx(DropdownItem, { icon: _jsx(CopyIcon, {}), onClick: () => {
                                                            const clipboard = buildClipboardFromDataType(dt, thisDmnsNamespace);
                                                            navigator.clipboard.writeText(JSON.stringify(clipboard));
                                                        }, children: "Copy" }, "copy-item"),
                                                    _jsx(React.Fragment, { children: !isReadOnly && (_jsx(DropdownItem, { icon: _jsx(CutIcon, {}), onClick: () => {
                                                                const clipboard = buildClipboardFromDataType(dt, thisDmnsNamespace);
                                                                navigator.clipboard.writeText(JSON.stringify(clipboard)).then(() => {
                                                                    editItemDefinition(dt.parentId, (itemDefinition) => {
                                                                        var _a;
                                                                        (_a = itemDefinition.itemComponent) === null || _a === void 0 ? void 0 : _a.splice(dt.index, 1);
                                                                    });
                                                                });
                                                            }, children: "Cut" }, "cut-item")) }, "cut-fragment"),
                                                    _jsx(React.Fragment, { children: !isReadOnly && (_jsx(DropdownItem, { icon: _jsx(TrashIcon, {}), onClick: () => {
                                                                editItemDefinition(dt.parentId, (itemDefinition) => {
                                                                    var _a;
                                                                    (_a = itemDefinition.itemComponent) === null || _a === void 0 ? void 0 : _a.splice(dt.index, 1);
                                                                });
                                                            }, children: "Remove" }, "remove-item")) }, "remove-fragment"),
                                                    !isReadOnly && isStruct(dt.itemDefinition) ? (_jsxs(React.Fragment, { children: [_jsx(DropdownSeparator, {}), _jsx(React.Fragment, { children: _jsx(DropdownItem, { icon: _jsx(PasteIcon, {}), onClick: () => {
                                                                        navigator.clipboard.readText().then((text) => {
                                                                            const clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
                                                                            if (!clipboard) {
                                                                                return;
                                                                            }
                                                                            getNewDmnIdRandomizer()
                                                                                .ack({
                                                                                json: clipboard.itemDefinitions,
                                                                                type: "DMN15__tDefinitions",
                                                                                attr: "itemDefinition",
                                                                            })
                                                                                .randomize();
                                                                            for (const itemDefinition of clipboard.itemDefinitions) {
                                                                                addItemComponent(dt.itemDefinition["@_id"], "unshift", itemDefinition);
                                                                            }
                                                                        });
                                                                    }, children: "Paste property" }) })] }, "paste-property-fragment")) : (_jsx(React.Fragment, {}, "paste-property-empty-fragment")),
                                                ] }) })] })) }, dt.itemDefinition["@_id"]));
                        }) }), !isReadOnly && (_jsx("tfoot", { children: _jsx("tr", { children: _jsx("td", { colSpan: 5, children: _jsxs(Button, { variant: ButtonVariant.link, onClick: () => addItemComponent(parent.itemDefinition["@_id"], "push", {
                                        "@_name": "New property",
                                        typeRef: undefined,
                                    }), style: { paddingLeft: 0 }, children: [_jsx(PlusCircleIcon, {}), "\u00A0\u00A0", `Add property to '${parent.itemDefinition["@_name"]}'`] }) }) }) }))] }))] }));
}
//# sourceMappingURL=ItemComponentsTable.js.map