import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useState, useCallback, useRef, useEffect } from "react";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { FeelInput } from "@kie-tools/feel-input-component/dist";
import "./ConstraintsExpression.css";
import { HelperText, HelperTextItem } from "@patternfly/react-core/dist/js/components/HelperText";
import InfoIcon from "@patternfly/react-icons/dist/js/icons/info-icon";
export function ConstraintsExpression({ id, isReadOnly, value, onSave, }) {
    const [preview, setPreview] = useState(value !== null && value !== void 0 ? value : "");
    const [isEditing, setEditing] = useState(false);
    const valueCopy = useRef(value);
    const onFeelBlur = useCallback((valueOnBlur) => {
        setEditing(false);
    }, []);
    const onFeelChange = useCallback((_, content, preview) => {
        setPreview(preview);
        onSave === null || onSave === void 0 ? void 0 : onSave(content.trim());
    }, [onSave]);
    const onPreviewChanged = useCallback((newPreview) => setPreview(newPreview), []);
    useEffect(() => {
        valueCopy.current = isEditing ? valueCopy.current : value;
    }, [isEditing, value]);
    const onKeyDown = useCallback((e) => {
        if (!isReadOnly && isEditing) {
            e.stopPropagation();
        }
        if (!isReadOnly && !isEditing) {
            setEditing(true);
        }
    }, [isEditing, isReadOnly]);
    const monacoOptions = useMemo(() => ({
        fixedOverflowWidgets: true,
        lineNumbers: "off",
        fontSize: 16,
        renderLineHighlight: "none",
        lineDecorationsWidth: 1,
        automaticLayout: true,
        "semanticHighlighting.enabled": true,
    }), []);
    return (_jsxs("div", { style: { display: "flex", flexDirection: "column", width: "100%" }, onKeyDown: onKeyDown, children: [isReadOnly && (_jsx(Title, { size: "md", headingLevel: "h5", style: { paddingBottom: "10px" }, children: "Equivalent FEEL expression:" })), _jsxs("div", { style: !isReadOnly
                    ? { flexGrow: 1, flexShrink: 0, border: "solid 1px lightgray", borderRadius: "4px" }
                    : { flexGrow: 1, flexShrink: 0, height: "22px" }, children: [isReadOnly &&
                        (value ? (_jsx("span", { "data-testid": "kie-tools--dmn-editor--readonly-expression-constraint-with-value", className: "editable-cell-value pf-u-text-break-word", dangerouslySetInnerHTML: { __html: preview } })) : (_jsx("p", { style: { fontStyle: "italic" }, children: `<None>` }))), _jsx(FeelInput, { value: isEditing ? valueCopy.current : value, onChange: onFeelChange, onBlur: onFeelBlur, onPreviewChanged: onPreviewChanged, enabled: !isReadOnly, options: monacoOptions })] }), _jsx(HelperText, { children: !isReadOnly && (_jsxs(HelperTextItem, { variant: "indeterminate", icon: _jsx(InfoIcon, {}), children: ["Check the", " ", _jsx("a", { target: "_blank", href: "https://kiegroup.github.io/dmn-feel-handbook/#feel-values", children: "FEEL handbook" }), " ", "to help you on creating your expressions."] })) })] }, id));
}
//# sourceMappingURL=ConstraintsExpression.js.map