import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import "./ConstraintDateTime.css";
import { ConstraintTime } from "./ConstraintTime";
import { ConstraintDate } from "./ConstraintDate";
export function ConstraintDateTime({ value, onChange, isValid, ...props }) {
    const date = useMemo(() => { var _a, _b; return (_b = (_a = value.split("T")) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : ""; }, [value]);
    const time = useMemo(() => { var _a, _b; return (_b = (_a = value.split("T")) === null || _a === void 0 ? void 0 : _a[1]) !== null && _b !== void 0 ? _b : ""; }, [value]);
    const onInternalChange = useCallback((args) => {
        var _a, _b;
        const newDate = (_a = args.date) !== null && _a !== void 0 ? _a : date;
        const newTime = (_b = args.time) !== null && _b !== void 0 ? _b : time;
        if (newDate !== "" && newTime === "") {
            onChange(`${newDate}`);
        }
        if (newDate !== "" && newTime !== "") {
            onChange(`${newDate}T${newTime}`);
        }
    }, [date, onChange, time]);
    const onChangeDate = useCallback((value) => {
        onInternalChange({ date: value });
    }, [onInternalChange]);
    const onChangeTime = useCallback((value) => {
        onInternalChange({ time: value });
    }, [onInternalChange]);
    return (_jsx(_Fragment, { children: _jsxs("div", { className: "kie-dmn-editor--constraint-date-time", children: [_jsx(ConstraintDate, { ...props, value: date, onChange: onChangeDate, isValid: isValid }), _jsx(ConstraintTime, { ...props, value: time, onChange: onChangeTime, isValid: isValid })] }) }));
}
//# sourceMappingURL=ConstraintDateTime.js.map