"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorYamlCodeCompletionStrategy = exports.isNodeUncompleted = exports.EditorYamlLanguageService = void 0;
exports.parseYamlContent = parseYamlContent;
var yaml_language_server_1 = require("@kie-tools/yaml-language-server");
var vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var yaml_language_server_parser_1 = require("yaml-language-server-parser");
var api_1 = require("../api");
var EditorLanguageService_1 = require("./EditorLanguageService");
var getLineContentFromOffset_1 = require("./getLineContentFromOffset");
var getNodeFormat_1 = require("./getNodeFormat");
var indentText_1 = require("./indentText");
var matchNodeWithLocation_1 = require("./matchNodeWithLocation");
var EditorYamlLanguageService = (function () {
    function EditorYamlLanguageService(args) {
        this.ls = args.ls;
        this.codeCompletionStrategy = args.codeCompletionStrategy;
    }
    EditorYamlLanguageService.prototype.getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var rootNode, doc, cursorOffset, isCurrentNodeUncompleted;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        rootNode = parseYamlContent(args.content);
                        doc = vscode_languageserver_textdocument_1.TextDocument.create(args.uri, api_1.FileLanguage.YAML, 0, args.content);
                        cursorOffset = doc.offsetAt(args.cursorPosition);
                        if (shouldNotComplete(args.content.slice(0, cursorOffset))) {
                            return [2, []];
                        }
                        isCurrentNodeUncompleted = rootNode
                            ? (0, exports.isNodeUncompleted)(__assign(__assign({}, args), { rootNode: rootNode, cursorOffset: cursorOffset }))
                            : false;
                        if (isCurrentNodeUncompleted) {
                            args.cursorPosition = vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character - 1);
                        }
                        return [4, this.ls.getCompletionItems(__assign(__assign({}, args), { rootNode: rootNode, codeCompletionStrategy: this.codeCompletionStrategy }))];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    EditorYamlLanguageService.prototype.getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.ls.getCodeLenses(__assign(__assign({}, args), { rootNode: parseYamlContent(args.content), codeCompletionStrategy: this.codeCompletionStrategy }))];
            });
        });
    };
    EditorYamlLanguageService.prototype.getDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var rootNode, loadErrors, error, position;
            return __generator(this, function (_a) {
                if (!args.content.trim()) {
                    return [2, []];
                }
                rootNode = parseYamlContent(args.content);
                loadErrors = !rootNode ? (0, yaml_language_server_parser_1.load)(args.content).errors : [];
                if (loadErrors.length > 0) {
                    error = loadErrors[0];
                    position = vscode_languageserver_types_1.Position.create(error.mark.line, error.mark.column);
                    return [2, [
                            {
                                message: error.message,
                                range: vscode_languageserver_types_1.Range.create(position, position),
                                severity: vscode_languageserver_types_1.DiagnosticSeverity.Error,
                            },
                        ]];
                }
                return [2, this.ls.getDiagnostics(__assign(__assign({}, args), { rootNode: rootNode, getSchemaDiagnostics: args.getSchemaDiagnostics }))];
            });
        });
    };
    EditorYamlLanguageService.prototype.getSchemaDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var schemaRequestService, workspaceContext, connection, telemetry, yamlSettings, yamlLanguageSettings, yamlLs;
            var _this = this;
            return __generator(this, function (_a) {
                schemaRequestService = function (uri) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        if (uri === args.jsonSchema.$id) {
                            return [2, Promise.resolve(JSON.stringify(args.jsonSchema))];
                        }
                        else {
                            throw new Error("Unable to load schema from '".concat(uri, "'"));
                        }
                        return [2];
                    });
                }); };
                workspaceContext = {
                    resolveRelativePath: function (_relativePath, _resource) {
                        return "";
                    },
                };
                connection = {};
                connection.onRequest = function () { return null; };
                telemetry = new yaml_language_server_1.Telemetry(connection);
                yamlSettings = { yamlFormatterSettings: { enable: false } };
                yamlLanguageSettings = {
                    validate: true,
                    completion: false,
                    format: false,
                    hover: false,
                    isKubernetes: false,
                    schemas: [{ fileMatch: args.fileMatch, uri: args.jsonSchema.$id }],
                };
                yamlLs = (0, yaml_language_server_1.getLanguageService)(schemaRequestService, workspaceContext, connection, telemetry, yamlSettings);
                yamlLs.configure(yamlLanguageSettings);
                return [2, yamlLs.doValidation(args.textDocument, false)];
            });
        });
    };
    EditorYamlLanguageService.prototype.dispose = function () {
        return this.ls.dispose();
    };
    return EditorYamlLanguageService;
}());
exports.EditorYamlLanguageService = EditorYamlLanguageService;
var isNodeUncompleted = function (args) {
    if (args.content.slice(args.cursorOffset - 1, args.cursorOffset) !== " ") {
        return false;
    }
    var nodeAtPrevOffset = (0, EditorLanguageService_1.findNodeAtOffset)(args.rootNode, args.cursorOffset - 1, true);
    if (!nodeAtPrevOffset) {
        return false;
    }
    return nodeAtPrevOffset.offset + nodeAtPrevOffset.length === args.cursorOffset - 1;
};
exports.isNodeUncompleted = isNodeUncompleted;
function shouldNotComplete(content) {
    return /(^|\n)\s*(([^:]+:)|(-))$/.test(content);
}
var astConvert = function (node, parentNode) {
    var convertedNode = {
        type: "object",
        offset: node.startPosition,
        length: node.endPosition - node.startPosition,
        parent: parentNode,
    };
    if (node.kind === yaml_language_server_parser_1.Kind.SCALAR) {
        convertedNode.value = node.value;
        convertedNode.type = "string";
    }
    else if (node.kind === yaml_language_server_parser_1.Kind.MAP) {
        var yamlMap = node;
        convertedNode.value = yamlMap.value;
        convertedNode.children = yamlMap.mappings.map(function (mapping) { return astConvert(mapping, convertedNode); });
        convertedNode.type = "object";
    }
    else if (node.kind === yaml_language_server_parser_1.Kind.MAPPING) {
        var yamlMapping = node;
        convertedNode.value = yamlMapping.value;
        convertedNode.children = __spreadArray([
            astConvert(yamlMapping.key, convertedNode)
        ], __read((convertedNode.value ? [astConvert(yamlMapping.value, convertedNode)] : [])), false);
        convertedNode.type = "property";
        convertedNode.colonOffset = yamlMapping.key.endPosition;
    }
    else if (node.kind === yaml_language_server_parser_1.Kind.SEQ) {
        convertedNode.children = node.items
            .filter(function (item) { return item; })
            .map(function (item) { return astConvert(item, convertedNode); });
        convertedNode.type = "array";
    }
    else if (node.kind === yaml_language_server_parser_1.Kind.ANCHOR_REF || node.kind === yaml_language_server_parser_1.Kind.INCLUDE_REF) {
        convertedNode.value = node.value;
        convertedNode.type = "object";
    }
    return convertedNode;
};
var EditorYamlCodeCompletionStrategy = (function () {
    function EditorYamlCodeCompletionStrategy() {
    }
    EditorYamlCodeCompletionStrategy.prototype.translate = function (args) {
        var _a, _b, _c, _d;
        var completionDump = (0, yaml_language_server_parser_1.dump)(args.completion, {}).slice(0, -1);
        if (["{}", "[]"].includes(completionDump) || args.completionItemKind === vscode_languageserver_types_1.CompletionItemKind.Text) {
            return completionDump;
        }
        var skipFirstLineIndent = args.completionItemKind !== vscode_languageserver_types_1.CompletionItemKind.Module;
        var completionItemNewLine = args.completionItemKind === vscode_languageserver_types_1.CompletionItemKind.Module ? "\n" : "";
        var completionText = completionItemNewLine + (0, indentText_1.indentText)(completionDump, 2, " ", skipFirstLineIndent);
        return [vscode_languageserver_types_1.CompletionItemKind.Interface, vscode_languageserver_types_1.CompletionItemKind.Reference].includes(args.completionItemKind) && (0, EditorLanguageService_1.positions_equals)((_b = (_a = args.overwriteRange) === null || _a === void 0 ? void 0 : _a.start) !== null && _b !== void 0 ? _b : null, (_d = (_c = args.currentNodeRange) === null || _c === void 0 ? void 0 : _c.start) !== null && _d !== void 0 ? _d : null)
            ? "- ".concat(completionText, "\n")
            : completionText;
    };
    EditorYamlCodeCompletionStrategy.prototype.formatLabel = function (label, completionItemKind) {
        return [vscode_languageserver_types_1.CompletionItemKind.Function, vscode_languageserver_types_1.CompletionItemKind.Folder].includes(completionItemKind)
            ? "'".concat(label, "'")
            : label;
    };
    EditorYamlCodeCompletionStrategy.prototype.getStartNodeValuePosition = function (document, node) {
        var position = document.positionAt(node.offset);
        var nextPosition = document.positionAt(node.offset + 1);
        var charAtPosition = document.getText(vscode_languageserver_types_1.Range.create(position, nextPosition));
        var isStartingCharJsonFormat = /"|'|\[|{/.test(charAtPosition);
        return isStartingCharJsonFormat ? nextPosition : position;
    };
    EditorYamlCodeCompletionStrategy.prototype.shouldComplete = function (args) {
        var _a;
        if (!args.root ||
            !args.node ||
            (["object", "array"].includes(args.node.type) && (0, getNodeFormat_1.getNodeFormat)(args.content, args.node) === api_1.FileLanguage.JSON) ||
            (["string", "number", "boolean"].includes(args.node.type) &&
                args.node.parent &&
                (0, getNodeFormat_1.getNodeFormat)(args.content, args.node.parent) === api_1.FileLanguage.JSON)) {
            return false;
        }
        if (((_a = args.node) === null || _a === void 0 ? void 0 : _a.type) === "array" && args.cursorOffset !== args.node.offset) {
            var lineContent = (0, getLineContentFromOffset_1.getLineContentFromOffset)(args.content, args.cursorOffset);
            var lineContentStartsWithDash = /^\s*- /.test(lineContent);
            if (!lineContentStartsWithDash) {
                return false;
            }
        }
        return (0, matchNodeWithLocation_1.matchNodeWithLocation)(args.root, args.node, args.path);
    };
    EditorYamlCodeCompletionStrategy.prototype.shouldCreateCodelens = function (args) {
        return (args.commandName !== "editor.ls.commands.OpenCompletionItems" ||
            (0, getNodeFormat_1.getNodeFormat)(args.content, args.node) !== api_1.FileLanguage.JSON);
    };
    return EditorYamlCodeCompletionStrategy;
}());
exports.EditorYamlCodeCompletionStrategy = EditorYamlCodeCompletionStrategy;
function parseYamlContent(content) {
    if (!content.trim()) {
        return;
    }
    var ast = (0, yaml_language_server_parser_1.load)(content);
    if (ast && ast.errors && ast.errors.length) {
        return;
    }
    return astConvert(ast);
}
//# sourceMappingURL=EditorYamlLanguageService.js.map