/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.apache.ignite3.internal.raft.Marshaller;

public class JDKMarshaller
implements Marshaller {
    public static final Marshaller INSTANCE = new JDKMarshaller();

    @Override
    public byte[] marshall(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public <T> T unmarshall(ByteBuffer raw) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(raw.array(), raw.arrayOffset() + raw.position(), raw.remaining());
            ObjectInputStream oos = new ObjectInputStream(bais);
            return (T)oos.readObject();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

