/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.conf.Configuration;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class ChangePeersAndLearnersAsyncRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ChangePeersAndLearnersAsyncRequest> {
    public ChangePeersAndLearnersAsyncRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.ChangePeersAndLearnersAsyncRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ChangePeersAndLearnersAsyncRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ChangePeersAndLearnersAsyncRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        List<PeerId> oldLearners = ctx.node.listLearners();
        Configuration conf = new Configuration();
        Iterator<String> iterator = request.newPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = iterator.next();
            if (peer.parse(peerIdStr)) {
                conf.addPeer(peer);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        iterator = request.newLearnersList().iterator();
        while (iterator.hasNext()) {
            PeerId learner = new PeerId();
            String learnerIdStr = iterator.next();
            if (learner.parse(learnerIdStr)) {
                conf.addLearner(learner);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse learner id %s", learnerIdStr);
        }
        long term = request.term();
        LOG.info("Receive ChangePeersAndLearnersAsyncRequest with term {} to {} from {}, new conf is {}", term, ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), conf);
        ctx.node.changePeersAndLearnersAsync(conf, term, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.ChangePeersAndLearnersAsyncResponse resp = this.msgFactory().changePeersAndLearnersAsyncResponse().oldPeersList(ChangePeersAndLearnersAsyncRequestProcessor.toStringList(oldPeers)).newPeersList(ChangePeersAndLearnersAsyncRequestProcessor.toStringList(conf.getPeers())).oldLearnersList(ChangePeersAndLearnersAsyncRequestProcessor.toStringList(oldLearners)).newLearnersList(ChangePeersAndLearnersAsyncRequestProcessor.toStringList(conf.getLearners())).build();
                done.sendResponse(resp);
            }
        });
        return null;
    }

    private static List<String> toStringList(Collection<?> collection) {
        return collection.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public String interest() {
        return CliRequests.ChangePeersAndLearnersAsyncRequest.class.getName();
    }
}

