/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.storage.state;

import org.apache.ignite3.internal.tx.storage.state.ThreadAssertingTxStatePartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingTxStateStorage
implements TxStateStorage {
    private final TxStateStorage wrappedStorage;

    public ThreadAssertingTxStateStorage(TxStateStorage wrappedStorage) {
        this.wrappedStorage = wrappedStorage;
    }

    @Override
    public TxStatePartitionStorage getOrCreatePartitionStorage(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return ThreadAssertingTxStateStorage.wrapTxStatePartitionStorage(this.wrappedStorage.getOrCreatePartitionStorage(partitionId));
    }

    @Override
    public TxStatePartitionStorage createPartitionStorage(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return ThreadAssertingTxStateStorage.wrapTxStatePartitionStorage(this.wrappedStorage.createPartitionStorage(partitionId));
    }

    private static ThreadAssertingTxStatePartitionStorage wrapTxStatePartitionStorage(TxStatePartitionStorage storage) {
        return storage instanceof ThreadAssertingTxStatePartitionStorage ? (ThreadAssertingTxStatePartitionStorage)storage : new ThreadAssertingTxStatePartitionStorage(storage);
    }

    @Override
    @Nullable
    public TxStatePartitionStorage getPartitionStorage(int partitionId) {
        TxStatePartitionStorage storage = this.wrappedStorage.getPartitionStorage(partitionId);
        return storage == null ? null : ThreadAssertingTxStateStorage.wrapTxStatePartitionStorage(storage);
    }

    @Override
    public void destroyPartitionStorage(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.wrappedStorage.destroyPartitionStorage(partitionId);
    }

    @Override
    public void start() {
        this.wrappedStorage.start();
    }

    @Override
    public void close() {
        this.wrappedStorage.close();
    }

    @Override
    public void destroy() {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.wrappedStorage.destroy();
    }
}

