/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.metrics;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.DistributionMetric;
import org.apache.ignite3.internal.metrics.LongAdderMetric;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.jetbrains.annotations.TestOnly;

public class TransactionMetricsSource
extends AbstractMetricSource<Holder> {
    private static final long[] HISTOGRAM_BUCKETS = new long[]{1L, 2L, 4L, 8L, 16L, 25L, 50L, 75L, 100L, 250L, 500L, 750L, 1000L, 3000L, 5000L, 10000L, 25000L, 60000L};
    public static final String SOURCE_NAME = "transactions";
    private final ClockService clockService;

    public TransactionMetricsSource(ClockService clockService) {
        super(SOURCE_NAME, "Transaction metrics.");
        this.clockService = clockService;
    }

    public void onReadWriteTransactionFinished(UUID transactionId, boolean commit) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.rwDuration.add(this.calculateTransactionDuration(transactionId));
            holder.activeTransactions.decrement();
            if (commit) {
                holder.totalCommits.increment();
                holder.rwCommits.increment();
            } else {
                holder.totalRollbacks.increment();
                holder.rwRollbacks.increment();
            }
        }
    }

    public void onReadOnlyTransactionFinished(UUID transactionId, boolean commit) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.roDuration.add(this.calculateTransactionDuration(transactionId));
            holder.activeTransactions.decrement();
            if (commit) {
                holder.totalCommits.increment();
                holder.roCommits.increment();
            } else {
                holder.totalRollbacks.increment();
                holder.roRollbacks.increment();
            }
        }
    }

    public void onTransactionStarted() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.activeTransactions.increment();
        }
    }

    public long activeTransactions() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            return holder.activeTransactions.value();
        }
        return 0L;
    }

    public long finishedTransactions() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            return holder.totalCommits.value() + holder.totalRollbacks.value();
        }
        return 0L;
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    private long calculateTransactionDuration(UUID transactionId) {
        return this.clockService.currentLong() - TransactionIds.beginTimestamp(transactionId).getPhysical();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongAdderMetric totalCommits = new LongAdderMetric("TotalCommits", "Total number of commits.");
        private final LongAdderMetric totalRollbacks = new LongAdderMetric("TotalRollbacks", "Total number of rollbacks.");
        private final LongAdderMetric rwCommits = new LongAdderMetric("RwCommits", "Total number of read-write transaction commits.");
        private final LongAdderMetric roCommits = new LongAdderMetric("RoCommits", "Total number of read-only transaction commits.");
        private final LongAdderMetric rwRollbacks = new LongAdderMetric("RwRollbacks", "Total number of rolled-back read-write transactions.");
        private final LongAdderMetric roRollbacks = new LongAdderMetric("RoRollbacks", "Total number of rolled-back read-only transactions.");
        private final DistributionMetric rwDuration = new DistributionMetric("RwDuration", ".", HISTOGRAM_BUCKETS);
        private final DistributionMetric roDuration = new DistributionMetric("RoDuration", ".", HISTOGRAM_BUCKETS);
        @TestOnly
        private final LongAdderMetric activeTransactions = new LongAdderMetric("Active", "Number of running transactions.");
        private final List<Metric> metrics = List.of(this.totalCommits, this.rwCommits, this.roCommits, this.totalRollbacks, this.rwRollbacks, this.roRollbacks, this.rwDuration, this.roDuration);

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

