/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.index;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

class IndexMetaSerializer
extends VersionedSerializer<IndexMeta> {
    static final IndexMetaSerializer INSTANCE = new IndexMetaSerializer();

    IndexMetaSerializer() {
    }

    @Override
    protected void writeExternalData(IndexMeta meta, IgniteDataOutput out) throws IOException {
        out.writeVarInt(meta.catalogVersion());
        out.writeVarInt(meta.indexId());
        out.writeVarInt(meta.tableId());
        out.writeVarInt(meta.tableVersion());
        out.writeUTF(meta.indexName());
        out.writeVarInt(meta.status().code());
        out.writeVarInt(meta.statusChanges().size());
        for (Map.Entry<MetaIndexStatus, MetaIndexStatusChange> entry : meta.statusChanges().entrySet()) {
            out.writeVarInt(entry.getKey().code());
            MetaIndexStatusChange change = entry.getValue();
            out.writeVarInt(change.catalogVersion());
            HybridTimestamp.hybridTimestamp(change.activationTimestamp()).writeTo(out);
        }
    }

    @Override
    protected IndexMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int catalogVersion = in.readVarIntAsInt();
        int indexId = in.readVarIntAsInt();
        int tableId = in.readVarIntAsInt();
        int tableVersion = in.readVarIntAsInt();
        String indexName = in.readUTF();
        MetaIndexStatus status = MetaIndexStatus.findByCode(in.readVarIntAsInt());
        Map<MetaIndexStatus, MetaIndexStatusChange> statusChanges = IndexMetaSerializer.readStatusChanges(in);
        return new IndexMeta(catalogVersion, indexId, tableId, tableVersion, indexName, status, statusChanges);
    }

    private static Map<MetaIndexStatus, MetaIndexStatusChange> readStatusChanges(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        EnumMap<MetaIndexStatus, MetaIndexStatusChange> map = new EnumMap<MetaIndexStatus, MetaIndexStatusChange>(MetaIndexStatus.class);
        for (int i = 0; i < length; ++i) {
            MetaIndexStatus status = MetaIndexStatus.findByCode(in.readVarIntAsInt());
            int catalogVersion = in.readVarIntAsInt();
            HybridTimestamp activationTimestamp = HybridTimestamp.readFrom(in);
            MetaIndexStatusChange change = new MetaIndexStatusChange(catalogVersion, activationTimestamp.longValue());
            map.put(status, change);
        }
        return map;
    }
}

