/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite3.internal.storage.RowId;
import org.jetbrains.annotations.Nullable;

class MvPartitionDeliveryState {
    private final Iterator<PartitionMvStorageAccess> partitionStoragesIterator;
    @Nullable
    private RowId currentRowId;
    @Nullable
    private PartitionMvStorageAccess currentPartitionStorage;
    private final IntSet tableIds;
    private boolean isStarted = false;

    MvPartitionDeliveryState(List<PartitionMvStorageAccess> partitionStorages) {
        this.partitionStoragesIterator = partitionStorages.iterator();
        this.tableIds = new IntOpenHashSet(partitionStorages.size());
        partitionStorages.forEach(storage -> this.tableIds.add(storage.tableId()));
    }

    RowId currentRowId() {
        assert (this.currentRowId != null);
        return this.currentRowId;
    }

    PartitionMvStorageAccess currentPartitionStorage() {
        assert (this.currentPartitionStorage != null);
        return this.currentPartitionStorage;
    }

    int currentTableId() {
        return this.currentPartitionStorage().tableId();
    }

    boolean isGoingToBeDelivered(int tableId) {
        return this.tableIds.contains(tableId);
    }

    boolean isExhausted() {
        return this.currentPartitionStorage == null && !this.partitionStoragesIterator.hasNext();
    }

    boolean hasIterationStarted() {
        return this.isStarted;
    }

    void advance() {
        this.isStarted = true;
        while (true) {
            if (this.currentPartitionStorage == null) {
                if (!this.partitionStoragesIterator.hasNext()) {
                    return;
                }
                this.currentPartitionStorage = this.partitionStoragesIterator.next();
                this.currentRowId = this.currentPartitionStorage.closestRowId(RowId.lowestRowId(this.currentPartitionStorage.partitionId()));
            } else {
                assert (this.currentRowId != null);
                this.currentRowId = this.currentRowId.increment();
                if (this.currentRowId != null) {
                    this.currentRowId = this.currentPartitionStorage.closestRowId(this.currentRowId);
                }
            }
            if (this.currentRowId != null) {
                return;
            }
            this.currentPartitionStorage = null;
        }
    }
}

