/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV1;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV1Builder;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;

class FinishTxCommandV1Deserializer
implements MessageDeserializer<FinishTxCommandV1> {
    private final FinishTxCommandV1Builder msg;

    FinishTxCommandV1Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.finishTxCommandV1();
    }

    @Override
    public Class<FinishTxCommandV1> klass() {
        return FinishTxCommandV1.class;
    }

    @Override
    public FinishTxCommandV1 getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp(tmp);
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Comparable<HybridTimestamp> tmp = reader.readList("partitionIds", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionIds((List<TablePartitionIdMessage>)((Object)tmp));
                reader.incrementState();
            }
            case 5: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 6: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FinishTxCommandV1.class);
    }
}

