/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.replacement;

import org.apache.ignite3.internal.util.GridUnsafe;

public class SegmentedLruPageList {
    private static final double PROTECTED_TO_TOTAL_PAGES_RATIO = 0.5;
    static final int NULL_IDX = -1;
    private int headIdx = -1;
    private int tailIdx = -1;
    private int probTailIdx = -1;
    private int protectedPagesCnt;
    private final int protectedPagesLimit;
    private final long linksPtr;
    private final long flagsPtr;

    public SegmentedLruPageList(int totalPagesCnt, long memPtr) {
        this.linksPtr = memPtr;
        this.flagsPtr = memPtr + ((long)totalPagesCnt << 3);
        GridUnsafe.setMemory(this.linksPtr, (long)totalPagesCnt << 3, (byte)-1);
        GridUnsafe.setMemory(this.flagsPtr, totalPagesCnt + 7 >> 3, (byte)0);
        this.protectedPagesLimit = (int)((double)totalPagesCnt * 0.5);
    }

    public synchronized int poll() {
        int idx = this.headIdx;
        if (idx != -1) {
            this.remove(idx);
        }
        return idx;
    }

    public synchronized void remove(int pageIdx) {
        this.remove0(pageIdx, this.protectedPage(pageIdx));
    }

    private void remove0(int pageIdx, boolean clearProtectedFlag) {
        assert (pageIdx != -1);
        int prevIdx = this.prev(pageIdx);
        int nextIdx = this.next(pageIdx);
        if (pageIdx == this.probTailIdx) {
            this.probTailIdx = prevIdx;
        }
        if (prevIdx == -1) {
            assert (this.headIdx == pageIdx) : "Unexpected LRU page index [headIdx=" + this.headIdx + ", pageIdx=" + pageIdx + "]";
            this.headIdx = nextIdx;
        } else {
            this.next(prevIdx, nextIdx);
        }
        if (nextIdx == -1) {
            assert (this.tailIdx == pageIdx) : "Unexpected LRU page index [tailIdx=" + this.tailIdx + ", pageIdx=" + pageIdx + "]";
            this.tailIdx = prevIdx;
        } else {
            this.prev(nextIdx, prevIdx);
        }
        this.clearLinks(pageIdx);
        if (clearProtectedFlag) {
            --this.protectedPagesCnt;
            this.protectedPage(pageIdx, false);
        }
    }

    public synchronized void addToTail(int pageIdx, boolean protectedPage) {
        assert (this.prev(pageIdx) == -1) : this.prev(pageIdx);
        assert (this.next(pageIdx) == -1) : this.next(pageIdx);
        if (this.headIdx == -1 || this.tailIdx == -1) {
            assert (this.headIdx == -1) : this.headIdx;
            assert (this.tailIdx == -1) : this.tailIdx;
            assert (this.probTailIdx == -1) : this.probTailIdx;
            assert (this.protectedPagesCnt == 0) : this.protectedPagesCnt;
            this.headIdx = pageIdx;
            this.tailIdx = pageIdx;
            if (protectedPage) {
                this.protectedPagesCnt = 1;
                this.protectedPage(pageIdx, true);
            } else {
                this.probTailIdx = pageIdx;
            }
            return;
        }
        if (protectedPage) {
            assert (this.next(this.tailIdx) == -1) : "Unexpected LRU page index [pageIdx=" + pageIdx + ", tailIdx=" + this.tailIdx + ", nextLruIdx=" + this.next(this.tailIdx) + "]";
            this.link(this.tailIdx, pageIdx);
            this.tailIdx = pageIdx;
            this.protectedPage(pageIdx, true);
            if (this.protectedPagesCnt >= this.protectedPagesLimit) {
                int n = this.probTailIdx = this.probTailIdx != -1 ? this.next(this.probTailIdx) : this.headIdx;
                assert (this.probTailIdx != -1);
                this.protectedPage(this.probTailIdx, false);
            } else {
                ++this.protectedPagesCnt;
            }
        } else {
            if (this.probTailIdx == -1) {
                assert (this.prev(this.headIdx) == -1) : "Unexpected LRU page index [pageIdx=" + pageIdx + ", headIdx=" + this.headIdx + ", prevLruIdx=" + this.prev(this.headIdx) + "]";
                this.link(pageIdx, this.headIdx);
                this.headIdx = pageIdx;
            } else {
                int protectedIdx = this.next(this.probTailIdx);
                this.link(this.probTailIdx, pageIdx);
                if (protectedIdx == -1) {
                    assert (this.probTailIdx == this.tailIdx) : "Unexpected LRU page index [probTailIdx=" + this.probTailIdx + ", tailIdx=" + this.tailIdx + "]";
                    this.tailIdx = pageIdx;
                } else {
                    this.link(pageIdx, protectedIdx);
                }
            }
            this.probTailIdx = pageIdx;
        }
    }

    public synchronized void moveToTail(int pageIdx) {
        if (this.tailIdx == pageIdx) {
            return;
        }
        this.remove0(pageIdx, false);
        if (this.protectedPage(pageIdx)) {
            this.link(this.tailIdx, pageIdx);
            this.tailIdx = pageIdx;
        } else {
            this.addToTail(pageIdx, true);
        }
    }

    private void link(int prevIdx, int nextIdx) {
        this.prev(nextIdx, prevIdx);
        this.next(prevIdx, nextIdx);
    }

    private void clearLinks(int pageIdx) {
        GridUnsafe.putLong(this.linksPtr + ((long)pageIdx << 3), -1L);
    }

    int prev(int pageIdx) {
        return GridUnsafe.getInt(this.linksPtr + ((long)pageIdx << 3));
    }

    private void prev(int pageIdx, int prevIdx) {
        GridUnsafe.putInt(this.linksPtr + ((long)pageIdx << 3), prevIdx);
    }

    int next(int pageIdx) {
        return GridUnsafe.getInt(this.linksPtr + ((long)pageIdx << 3) + 4L);
    }

    private void next(int pageIdx, int nextIdx) {
        GridUnsafe.putInt(this.linksPtr + ((long)pageIdx << 3) + 4L, nextIdx);
    }

    boolean protectedPage(int pageIdx) {
        long flags = GridUnsafe.getLong(this.flagsPtr + (long)(pageIdx >> 3 & 0xFFFFFFF8));
        return (flags & 1L << pageIdx) != 0L;
    }

    private void protectedPage(int pageIdx, boolean protectedPage) {
        long ptr = this.flagsPtr + (long)(pageIdx >> 3 & 0xFFFFFFF8);
        if (protectedPage) {
            GridUnsafe.putLong(ptr, GridUnsafe.getLong(ptr) | 1L << pageIdx);
        } else {
            GridUnsafe.putLong(ptr, GridUnsafe.getLong(ptr) & (1L << pageIdx ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    synchronized int headIdx() {
        return this.headIdx;
    }

    synchronized int probTailIdx() {
        return this.probTailIdx;
    }

    synchronized int tailIdx() {
        return this.tailIdx;
    }

    synchronized int protectedPagesCount() {
        return this.protectedPagesCnt;
    }

    int protectedPagesLimit() {
        return this.protectedPagesLimit;
    }

    public static long requiredMemory(int pagesCnt) {
        return (long)(pagesCnt * 8 + (pagesCnt + 63) / 8) & 0xFFFFFFFFFFFFFFF8L;
    }
}

