/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.DataRegion;
import org.apache.ignite3.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.AwaitTasksCompletionExecutor;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.Checkpoint;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.DataRegionDirtyPages;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.DataRegionsDirtyPages;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.DirtyPagesAndPartitions;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.IgniteCheckpointThreadFactory;
import org.apache.ignite3.internal.thread.IgniteThread;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

class CheckpointWorkflow {
    static final int PARALLEL_SORT_THRESHOLD = 40000;
    private static final IgniteLogger LOG = Loggers.forClass(CheckpointWorkflow.class);
    private final CheckpointReadWriteLock checkpointReadWriteLock;
    private final Collection<? extends DataRegion<PersistentPageMemory>> dataRegions;
    private final List<IgniteBiTuple<CheckpointListener, DataRegion<PersistentPageMemory>>> listeners = new CopyOnWriteArrayList<IgniteBiTuple<CheckpointListener, DataRegion<PersistentPageMemory>>>();
    private final ForkJoinPool parallelSortThreadPool;
    @Nullable
    private final ExecutorService callbackListenerThreadPool;
    private Map<DataRegion<?>, Set<DirtyFullPageId>> dirtyPartitionsMap = new ConcurrentHashMap();

    public CheckpointWorkflow(String igniteInstanceName, CheckpointReadWriteLock checkpointReadWriteLock, Collection<? extends DataRegion<PersistentPageMemory>> dataRegions, int checkpointThreads) {
        this.checkpointReadWriteLock = checkpointReadWriteLock;
        this.dataRegions = dataRegions;
        this.parallelSortThreadPool = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors(), 8) + 1, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(IgniteThread.threadPrefix(igniteInstanceName, "checkpoint-pages-sorter") + worker.getPoolIndex());
            return worker;
        }, null, false);
        this.callbackListenerThreadPool = checkpointThreads > 1 ? Executors.newFixedThreadPool(checkpointThreads, IgniteCheckpointThreadFactory.create(igniteInstanceName, "checkpoint-runner-callback-listener", false, LOG, new ThreadOperation[0])) : null;
    }

    public void start() {
    }

    public void stop() {
        this.listeners.clear();
        IgniteUtils.shutdownAndAwaitTermination(this.parallelSortThreadPool, 10L, TimeUnit.SECONDS);
        if (this.callbackListenerThreadPool != null) {
            IgniteUtils.shutdownAndAwaitTermination(this.callbackListenerThreadPool, 2L, TimeUnit.MINUTES);
        }
    }

    public void markPartitionAsDirty(DataRegion<?> dataRegion, int groupId, int partitionId, int partitionGeneration) {
        Set dirtyMetaPageIds = this.dirtyPartitionsMap.computeIfAbsent(dataRegion, unused -> ConcurrentHashMap.newKeySet());
        dirtyMetaPageIds.add(new DirtyFullPageId(PartitionMeta.partitionMetaPageId(partitionId), groupId, partitionGeneration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpoint markCheckpointBegin(long startCheckpointTimestamp, CheckpointProgressImpl curr, CheckpointMetricsTracker tracker, Runnable updateHeartbeat, Runnable onReleaseWriteLock) throws IgniteInternalCheckedException {
        DataRegionsDirtyPages dirtyPages;
        List<CheckpointListener> listeners = this.collectCheckpointListeners(this.dataRegions);
        AwaitTasksCompletionExecutor executor = this.callbackListenerThreadPool == null ? null : new AwaitTasksCompletionExecutor(this.callbackListenerThreadPool, updateHeartbeat);
        this.checkpointReadWriteLock.readLock();
        try {
            updateHeartbeat.run();
            for (CheckpointListener checkpointListener : listeners) {
                checkpointListener.beforeCheckpointBegin(curr, executor);
                if (executor != null) continue;
                updateHeartbeat.run();
            }
            if (executor != null) {
                executor.awaitPendingTasksFinished();
            }
        }
        finally {
            this.checkpointReadWriteLock.readUnlock();
        }
        tracker.onWriteLockWaitStart();
        this.checkpointReadWriteLock.writeLock();
        tracker.onWriteLockWaitEnd();
        tracker.onWriteLockHoldStart();
        try {
            updateHeartbeat.run();
            curr.transitTo(CheckpointState.LOCK_TAKEN);
            tracker.onMarkCheckpointBeginStart();
            for (CheckpointListener listener : listeners) {
                listener.onMarkCheckpointBegin(curr, executor);
                if (executor != null) continue;
                updateHeartbeat.run();
            }
            if (executor != null) {
                executor.awaitPendingTasksFinished();
            }
            tracker.onMarkCheckpointBeginEnd();
            dirtyPages = this.beginCheckpoint(curr);
            curr.currentCheckpointPagesCount(dirtyPages.dirtyPageCount);
            curr.transitTo(CheckpointState.PAGES_SNAPSHOT_TAKEN);
        }
        finally {
            this.checkpointReadWriteLock.writeUnlock();
            tracker.onWriteLockHoldEnd();
            onReleaseWriteLock.run();
        }
        curr.transitTo(CheckpointState.LOCK_RELEASED);
        for (CheckpointListener listener : listeners) {
            listener.onCheckpointBegin(curr);
            updateHeartbeat.run();
        }
        if (dirtyPages.dirtyPageCount > 0) {
            tracker.onSplitAndSortCheckpointPagesStart();
            updateHeartbeat.run();
            CheckpointDirtyPages checkpointDirtyPages = this.createAndSortCheckpointDirtyPages(dirtyPages);
            curr.pagesToWrite(checkpointDirtyPages);
            curr.initCounters(checkpointDirtyPages.dirtyPagesCount());
            tracker.onSplitAndSortCheckpointPagesEnd();
            curr.transitTo(CheckpointState.PAGES_SORTED);
            return new Checkpoint(checkpointDirtyPages, curr);
        }
        return new Checkpoint(CheckpointDirtyPages.EMPTY, curr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCheckpointEnd(Checkpoint chp) throws IgniteInternalCheckedException {
        CheckpointWorkflow checkpointWorkflow = this;
        synchronized (checkpointWorkflow) {
            for (DataRegion<PersistentPageMemory> dataRegion : this.dataRegions) {
                dataRegion.pageMemory().finishCheckpoint();
            }
        }
        if (chp.hasDelta()) {
            chp.progress.pagesToWrite(null);
            chp.progress.clearCounters();
        }
        for (CheckpointListener listener : this.collectCheckpointListeners(this.dataRegions)) {
            listener.afterCheckpointEnd(chp.progress);
        }
        chp.progress.transitTo(CheckpointState.FINISHED);
    }

    public void addCheckpointListener(CheckpointListener listener, @Nullable DataRegion<PersistentPageMemory> dataRegion) {
        assert (dataRegion == null || this.dataRegions.contains(dataRegion)) : dataRegion;
        this.listeners.add(new IgniteBiTuple<CheckpointListener, DataRegion<PersistentPageMemory>>(listener, dataRegion));
    }

    public void removeCheckpointListener(final CheckpointListener listener) {
        this.listeners.remove(new IgniteBiTuple<CheckpointListener, DataRegion<PersistentPageMemory>>(){

            @Override
            public boolean equals(Object o) {
                return listener == ((IgniteBiTuple)o).getKey();
            }

            @Override
            public int hashCode() {
                return listener.hashCode();
            }
        });
    }

    public List<CheckpointListener> collectCheckpointListeners(Collection<? extends DataRegion<PersistentPageMemory>> dataRegions) {
        return this.listeners.stream().filter(tuple -> tuple.getValue() == null || dataRegions.contains(tuple.getValue())).map(IgniteBiTuple::getKey).collect(Collectors.toUnmodifiableList());
    }

    private DataRegionsDirtyPages beginCheckpoint(CheckpointProgressImpl checkpointProgress) {
        assert (this.checkpointReadWriteLock.isWriteLockHeldByCurrentThread());
        Map<DataRegion<?>, Set<DirtyFullPageId>> dirtyPartitionsMap = this.dirtyPartitionsMap;
        this.dirtyPartitionsMap = new ConcurrentHashMap();
        ArrayList<DataRegionDirtyPages<Collection<DirtyFullPageId>>> dataRegionsDirtyPages = new ArrayList<DataRegionDirtyPages<Collection<DirtyFullPageId>>>(this.dataRegions.size());
        for (DataRegion<PersistentPageMemory> dataRegion : this.dataRegions) {
            Collection<DirtyFullPageId> dirtyPages = dataRegion.pageMemory().beginCheckpoint(checkpointProgress);
            Set<DirtyFullPageId> dirtyMetaPageIds = dirtyPartitionsMap.remove(dataRegion);
            if (dirtyMetaPageIds != null) {
                dirtyPages = CollectionUtils.concat(new Collection[]{dirtyMetaPageIds, dirtyPages});
            }
            dataRegionsDirtyPages.add(new DataRegionDirtyPages<Collection<DirtyFullPageId>>(dataRegion.pageMemory(), dirtyPages));
        }
        for (Map.Entry entry : dirtyPartitionsMap.entrySet()) {
            Object pageMemory = ((DataRegion)entry.getKey()).pageMemory();
            assert (pageMemory instanceof PersistentPageMemory);
            dataRegionsDirtyPages.add(new DataRegionDirtyPages<Collection>((PersistentPageMemory)pageMemory, (Collection)entry.getValue()));
        }
        return new DataRegionsDirtyPages(dataRegionsDirtyPages);
    }

    CheckpointDirtyPages createAndSortCheckpointDirtyPages(DataRegionsDirtyPages dataRegionsDirtyPages) throws IgniteInternalCheckedException {
        ArrayList<DirtyPagesAndPartitions> checkpointDirtyPages = new ArrayList<DirtyPagesAndPartitions>();
        int realPagesArrSize = 0;
        for (DataRegionDirtyPages<Collection<DirtyFullPageId>> dataRegionDirtyPages : dataRegionsDirtyPages.dirtyPages) {
            DirtyFullPageId[] pageIds2 = new DirtyFullPageId[((Collection)dataRegionDirtyPages.dirtyPages).size()];
            HashSet<GroupPartitionId> partitionIds = new HashSet<GroupPartitionId>();
            int pagePos = 0;
            for (DirtyFullPageId dirtyPage : (Collection)dataRegionDirtyPages.dirtyPages) {
                assert (realPagesArrSize++ != dataRegionsDirtyPages.dirtyPageCount) : "Incorrect estimated dirty pages number: " + dataRegionsDirtyPages.dirtyPageCount;
                pageIds2[pagePos++] = dirtyPage;
                partitionIds.add(GroupPartitionId.convert(dirtyPage));
            }
            if (pagePos == 0) continue;
            if (pagePos != pageIds2.length) {
                pageIds2 = Arrays.copyOf(pageIds2, pagePos);
            }
            checkpointDirtyPages.add(new DirtyPagesAndPartitions(dataRegionDirtyPages.pageMemory, pageIds2, partitionIds));
        }
        List parallelSortTasks = checkpointDirtyPages.stream().map(dirtyPagesAndPartitions -> dirtyPagesAndPartitions.dirtyPages).filter(pageIds -> ((DirtyFullPageId[])pageIds).length >= 40000).map(pageIds -> this.parallelSortThreadPool.submit(() -> Arrays.parallelSort(pageIds, CheckpointDirtyPages.DIRTY_PAGE_COMPARATOR))).collect(Collectors.toList());
        for (DirtyPagesAndPartitions dirtyPagesAndPartitions2 : checkpointDirtyPages) {
            if (dirtyPagesAndPartitions2.dirtyPages.length >= 40000) continue;
            Arrays.sort(dirtyPagesAndPartitions2.dirtyPages, CheckpointDirtyPages.DIRTY_PAGE_COMPARATOR);
        }
        for (ForkJoinTask parallelSortTask : parallelSortTasks) {
            try {
                parallelSortTask.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IgniteInternalCheckedException("Failed to perform pages array parallel sort", e instanceof ExecutionException ? e.getCause() : e);
            }
        }
        return new CheckpointDirtyPages(checkpointDirtyPages);
    }
}

