/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.ignite3.internal.network.configuration.KeyStoreView;

public final class KeystoreLoader {
    private KeystoreLoader() {
    }

    public static KeyStore load(KeyStoreView keyStoreConfiguration) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        char[] password = keyStoreConfiguration.password() == null ? null : keyStoreConfiguration.password().toCharArray();
        KeyStore ks = KeyStore.getInstance(keyStoreConfiguration.type());
        try (InputStream is = Files.newInputStream(Path.of(keyStoreConfiguration.path(), new String[0]), new OpenOption[0]);){
            ks.load(is, password);
        }
        return ks;
    }
}

