/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartMessageBuilder;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class HandshakeStartMessageImpl
implements HandshakeStartMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final String productName;
    @IgniteToStringInclude
    private final String productVersion;
    @IgniteToStringInclude
    private final UUID serverClusterId;
    @IgniteToStringInclude
    private final ClusterNodeMessage serverNode;

    private HandshakeStartMessageImpl(String productName, String productVersion, UUID serverClusterId, ClusterNodeMessage serverNode) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.serverClusterId = serverClusterId;
        this.serverNode = serverNode;
    }

    @Override
    public String productName() {
        return this.productName;
    }

    @Override
    public String productVersion() {
        return this.productVersion;
    }

    @Override
    public UUID serverClusterId() {
        return this.serverClusterId;
    }

    @Override
    public ClusterNodeMessage serverNode() {
        return this.serverNode;
    }

    public MessageSerializer serializer() {
        return HandshakeStartMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartMessageImpl otherMessage = (HandshakeStartMessageImpl)other;
        return Objects.equals(this.productName, otherMessage.productName) && Objects.equals(this.productVersion, otherMessage.productVersion) && Objects.equals(this.serverClusterId, otherMessage.serverClusterId) && Objects.equals(this.serverNode, otherMessage.serverNode);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.productName, this.productVersion, this.serverClusterId, this.serverNode);
        return result;
    }

    @Override
    public HandshakeStartMessageImpl clone() {
        try {
            return (HandshakeStartMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeStartMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.serverNode != null) {
            this.serverNode.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.serverNode != null) {
            this.serverNode.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements HandshakeStartMessageBuilder {
        private String productName;
        private String productVersion;
        private UUID serverClusterId;
        private ClusterNodeMessage serverNode;

        private Builder() {
        }

        @Override
        public HandshakeStartMessageBuilder productName(String productName) {
            Objects.requireNonNull(productName, "productName is not marked @Nullable");
            this.productName = productName;
            return this;
        }

        @Override
        public HandshakeStartMessageBuilder productVersion(String productVersion) {
            Objects.requireNonNull(productVersion, "productVersion is not marked @Nullable");
            this.productVersion = productVersion;
            return this;
        }

        @Override
        public HandshakeStartMessageBuilder serverClusterId(UUID serverClusterId) {
            this.serverClusterId = serverClusterId;
            return this;
        }

        @Override
        public HandshakeStartMessageBuilder serverNode(ClusterNodeMessage serverNode) {
            Objects.requireNonNull(serverNode, "serverNode is not marked @Nullable");
            this.serverNode = serverNode;
            return this;
        }

        @Override
        public String productName() {
            return this.productName;
        }

        @Override
        public String productVersion() {
            return this.productVersion;
        }

        @Override
        public UUID serverClusterId() {
            return this.serverClusterId;
        }

        @Override
        public ClusterNodeMessage serverNode() {
            return this.serverNode;
        }

        @Override
        public HandshakeStartMessage build() {
            return new HandshakeStartMessageImpl(Objects.requireNonNull(this.productName, "productName is not marked @Nullable"), Objects.requireNonNull(this.productVersion, "productVersion is not marked @Nullable"), this.serverClusterId, Objects.requireNonNull(this.serverNode, "serverNode is not marked @Nullable"));
        }
    }
}

