/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class FieldDescriptorMessageDeserializer
implements MessageDeserializer<FieldDescriptorMessage> {
    private final FieldDescriptorMessageBuilder msg;

    FieldDescriptorMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.fieldDescriptorMessage();
    }

    @Override
    public Class<FieldDescriptorMessage> klass() {
        return FieldDescriptorMessage.class;
    }

    @Override
    public FieldDescriptorMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("className");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.className(tmp);
                reader.incrementState();
            }
            case 1: {
                byte tmp = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.flags(tmp);
                reader.incrementState();
            }
            case 2: {
                String tmp = reader.readString("name");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.name(tmp);
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("typeDescriptorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.typeDescriptorId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FieldDescriptorMessage.class);
    }
}

