/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.network.configuration.MulticastAddress;

public class MulticastAddressValidator
implements Validator<MulticastAddress, String> {
    public static final MulticastAddressValidator INSTANCE = new MulticastAddressValidator();

    @Override
    public void validate(MulticastAddress annotation, ValidationContext<String> ctx) {
        String multicastGroup = ctx.getNewValue();
        try {
            InetAddress address = InetAddress.getByName(multicastGroup);
            if (!address.isMulticastAddress()) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Multicast group is not multicast"));
            }
        }
        catch (UnknownHostException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Multicast group is not a valid address"));
        }
    }
}

