/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server.persistence;

import java.util.Arrays;
import org.apache.ignite3.internal.util.HashUtils;

class WriteBatchProtector {
    private static final int BLOOM_BITS = 14;
    private static final int BLOOM_MASK = 16383;
    private static final int LSB_BITS = Integer.numberOfTrailingZeros(64);
    private static final int LSB_MASK = 63;
    private final long[] bloom = new long[16384 >>> LSB_BITS];

    WriteBatchProtector() {
    }

    public void onUpdate(byte[] key) {
        int h = WriteBatchProtector.hash(key);
        int msb = WriteBatchProtector.indexInsideArray(h);
        int lsb = WriteBatchProtector.indexInsideLongValue(h);
        int n = msb;
        this.bloom[n] = this.bloom[n] | WriteBatchProtector.singleBitInLong(lsb);
    }

    public boolean maybeUpdated(byte[] key) {
        int lsb;
        int h = WriteBatchProtector.hash(key);
        int msb = WriteBatchProtector.indexInsideArray(h);
        return (this.bloom[msb] & WriteBatchProtector.singleBitInLong(lsb = WriteBatchProtector.indexInsideLongValue(h))) != 0L;
    }

    private static int indexInsideArray(int h) {
        return h >>> LSB_BITS;
    }

    private static int indexInsideLongValue(int h) {
        return h & 0x3F;
    }

    private static long singleBitInLong(int lsb) {
        return 1L << lsb;
    }

    public void clear() {
        Arrays.fill(this.bloom, 0L);
    }

    private static int hash(byte[] key) {
        return HashUtils.hash32(key) & 0x3FFF;
    }
}

