/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones.rebalance;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite3.internal.distributionzones.rebalance.PartitionMover;
import org.apache.ignite3.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite3.internal.metastorage.dsl.Statements;
import org.apache.ignite3.internal.metastorage.dsl.Update;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsChain;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite3.internal.partitiondistribution.PendingAssignmentsCalculator;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.RaftError;
import org.apache.ignite3.internal.raft.RaftGroupEventsListener;
import org.apache.ignite3.internal.raft.Status;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.TestOnly;

public class RebalanceRaftGroupEventsListener
implements RaftGroupEventsListener {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceRaftGroupEventsListener.class);
    private static final int REBALANCE_RETRY_THRESHOLD = 10;
    private static final int SWITCH_APPEND_SUCCESS = 1;
    private static final int SWITCH_REDUCE_SUCCESS = 2;
    private static final int SCHEDULE_PENDING_REBALANCE_SUCCESS = 3;
    private static final int FINISH_REBALANCE_SUCCESS = 4;
    private static final int SWITCH_APPEND_FAIL = -1;
    private static final int SWITCH_REDUCE_FAIL = -2;
    private static final int SCHEDULE_PENDING_REBALANCE_FAIL = -3;
    private static final int FINISH_REBALANCE_FAIL = -4;
    private final MetaStorageManager metaStorageMgr;
    private final FailureProcessor failureProcessor;
    private final TablePartitionId tablePartitionId;
    private final IgniteSpinBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;
    private final PartitionMover partitionMover;
    private final AtomicInteger rebalanceAttempts = new AtomicInteger(0);
    private final SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration;
    private final BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn;

    public RebalanceRaftGroupEventsListener(MetaStorageManager metaStorageMgr, FailureProcessor failureProcessor, TablePartitionId tablePartitionId, IgniteSpinBusyLock busyLock, PartitionMover partitionMover, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn, ScheduledExecutorService rebalanceScheduler, SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration) {
        this.metaStorageMgr = metaStorageMgr;
        this.failureProcessor = failureProcessor;
        this.tablePartitionId = tablePartitionId;
        this.busyLock = busyLock;
        this.partitionMover = partitionMover;
        this.calculateAssignmentsFn = calculateAssignmentsFn;
        this.rebalanceScheduler = rebalanceScheduler;
        this.retryDelayConfiguration = retryDelayConfiguration;
    }

    @Override
    public void onLeaderElected(long term, long configurationTerm, long configurationIndex, PeersAndLearners configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewPeersConfigurationApplied(PeersAndLearners configuration, long term, long index) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            Set<Assignment> stable = RebalanceRaftGroupEventsListener.createAssignments(configuration);
            this.rebalanceScheduler.execute(() -> {
                if (!this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    this.doStableKeySwitchWithExceptionHandling(stable, this.tablePartitionId, term, index, this.calculateAssignmentsFn);
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            });
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReconfigurationError(Status status, PeersAndLearners configuration, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            assert (status != null);
            if (status.equals(Status.LEADER_STEPPED_DOWN)) {
                LOG.info("Leader stepped down during rebalance [partId={}]", this.tablePartitionId);
                return;
            }
            RaftError raftError = status.error();
            assert (raftError == RaftError.ECATCHUP) : "According to the JRaft protocol, " + RaftError.ECATCHUP + " is expected, got " + raftError;
            LOG.debug("Error occurred during rebalance [partId={}]", this.tablePartitionId);
            if (this.rebalanceAttempts.incrementAndGet() < 10) {
                this.scheduleChangePeersAndLearners(configuration, term);
            } else {
                LOG.info("Number of retries for rebalance exceeded the threshold [partId={}, threshold={}]", this.tablePartitionId, 10);
                this.scheduleChangePeersAndLearners(configuration, term);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    public int currentRetryDelay() {
        return this.retryDelayConfiguration.currentValue();
    }

    private void scheduleChangePeersAndLearners(PeersAndLearners peersAndLearners, long term) {
        this.rebalanceScheduler.schedule(() -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            LOG.info("Going to retry rebalance [attemptNo={}, partId={}]", this.rebalanceAttempts.get(), this.tablePartitionId);
            try {
                this.partitionMover.movePartition(peersAndLearners, term).whenComplete((unused, ex) -> {
                    if (ex != null && !ExceptionUtils.hasCause(ex, NodeStoppingException.class)) {
                        String errorMessage = String.format("Failure while moving partition [partId=%s]", this.tablePartitionId);
                        this.failureProcessor.process(new FailureContext((Throwable)ex, errorMessage));
                    }
                });
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, (long)this.retryDelayConfiguration.currentValue().intValue(), TimeUnit.MILLISECONDS);
    }

    private void doStableKeySwitchWithExceptionHandling(Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, long configurationTerm, long configurationIndex, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn) {
        this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn).whenComplete((res, ex) -> {
            if (ex != null && !ExceptionUtils.hasCause(ex, NodeStoppingException.class)) {
                if (ExceptionUtils.hasCause(ex, TimeoutException.class)) {
                    LOG.error("Unable to commit partition configuration to metastore: {}", (Throwable)ex, (Object)tablePartitionId);
                } else {
                    String errorMessage = String.format("Unable to commit partition configuration to metastore: %s", tablePartitionId);
                    this.failureProcessor.process(new FailureContext((Throwable)ex, errorMessage));
                }
            }
        });
    }

    private CompletableFuture<Void> doStableKeySwitch(Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, long configurationTerm, long configurationIndex, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn) {
        ByteArray pendingPartAssignmentsKey = RebalanceUtil.pendingPartAssignmentsQueueKey(tablePartitionId);
        ByteArray stablePartAssignmentsKey = RebalanceUtil.stablePartAssignmentsKey(tablePartitionId);
        ByteArray plannedPartAssignmentsKey = RebalanceUtil.plannedPartAssignmentsKey(tablePartitionId);
        ByteArray switchReduceKey = RebalanceUtil.switchReduceKey(tablePartitionId);
        ByteArray switchAppendKey = RebalanceUtil.switchAppendKey(tablePartitionId);
        ByteArray assignmentsChainKey = RebalanceUtil.assignmentsChainKey(tablePartitionId);
        Set<ByteArray> keysToGet = Set.of(plannedPartAssignmentsKey, pendingPartAssignmentsKey, stablePartAssignmentsKey, switchReduceKey, switchAppendKey, assignmentsChainKey);
        return this.metaStorageMgr.getAll(keysToGet).thenCompose(values -> {
            Entry stableEntry = (Entry)values.get(stablePartAssignmentsKey);
            Entry pendingEntry = (Entry)values.get(pendingPartAssignmentsKey);
            Entry plannedEntry = (Entry)values.get(plannedPartAssignmentsKey);
            Entry switchReduceEntry = (Entry)values.get(switchReduceKey);
            Entry switchAppendEntry = (Entry)values.get(switchAppendKey);
            Entry assignmentsChainEntry = (Entry)values.get(assignmentsChainKey);
            AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes(pendingEntry.value());
            if (pendingAssignmentsQueue != null && pendingAssignmentsQueue.size() > 1) {
                if (pendingAssignmentsQueue.peekFirst().nodes().equals(stableFromRaft)) {
                    pendingAssignmentsQueue.poll();
                }
                Assignments stable = Assignments.of(stableFromRaft, pendingAssignmentsQueue.peekFirst().timestamp());
                AssignmentsQueue pendingAssignmentsQueueFinal = pendingAssignmentsQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(stable).target(pendingAssignmentsQueue.peekLast()).toQueue();
                return this.metaStorageMgr.invoke(Statements.iif((Condition)Conditions.revision(pendingPartAssignmentsKey).eq(pendingEntry.revision()), Operations.ops(Operations.put(pendingPartAssignmentsKey, pendingAssignmentsQueue.toBytes())).yield(true), Operations.ops(new Operation[0]).yield(false))).thenCompose(statementResult -> {
                    boolean updated = statementResult.getAsBoolean();
                    if (updated) {
                        LOG.info("Pending assignments queue polled and updated [tablePartitionId={}, pendingQueue={}]", tablePartitionId, pendingAssignmentsQueueFinal);
                        return CompletableFutures.nullCompletedFuture();
                    }
                    LOG.info("Pending assignments queue update retry [tablePartitionId={}, pendingQueue={}]", tablePartitionId, pendingAssignmentsQueueFinal);
                    return this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn);
                });
            }
            Set<Assignment> retrievedStable = RebalanceRaftGroupEventsListener.readAssignments(stableEntry).nodes();
            Set<Assignment> retrievedSwitchReduce = RebalanceRaftGroupEventsListener.readAssignments(switchReduceEntry).nodes();
            Set<Assignment> retrievedSwitchAppend = RebalanceRaftGroupEventsListener.readAssignments(switchAppendEntry).nodes();
            Assignments pendingAssignments = pendingAssignmentsQueue == null ? Assignments.EMPTY : pendingAssignmentsQueue.poll();
            Set<Assignment> retrievedPending = pendingAssignments.nodes();
            if (!retrievedPending.equals(stableFromRaft)) {
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)calculateAssignmentsFn.apply(tablePartitionId, pendingAssignments.timestamp())).thenCompose(calculatedAssignments -> {
                Update failCase;
                Update successCase;
                Set reducedNodes = CollectionUtils.difference(retrievedSwitchReduce, stableFromRaft);
                Set addedNodes = CollectionUtils.difference(stableFromRaft, retrievedStable);
                Set<Assignment> calculatedSwitchReduce = CollectionUtils.difference(retrievedSwitchReduce, reducedNodes);
                Set<Assignment> calculatedSwitchAppend = RebalanceUtil.union(retrievedSwitchAppend, reducedNodes);
                calculatedSwitchAppend = CollectionUtils.difference(calculatedSwitchAppend, addedNodes);
                calculatedSwitchAppend = CollectionUtils.intersect(calculatedAssignments, calculatedSwitchAppend);
                Set<Assignment> calculatedPendingReduction = CollectionUtils.difference(stableFromRaft, retrievedSwitchReduce);
                Set<Assignment> calculatedPendingAddition = RebalanceUtil.union(stableFromRaft, reducedNodes);
                calculatedPendingAddition = CollectionUtils.intersect(calculatedAssignments, calculatedPendingAddition);
                SimpleCondition con1 = stableEntry.empty() ? Conditions.notExists(stablePartAssignmentsKey) : Conditions.revision(stablePartAssignmentsKey).eq(stableEntry.revision());
                SimpleCondition con2 = Conditions.revision(pendingPartAssignmentsKey).eq(pendingEntry.revision());
                SimpleCondition con3 = switchReduceEntry.empty() ? Conditions.notExists(switchReduceKey) : Conditions.revision(switchReduceKey).eq(switchReduceEntry.revision());
                SimpleCondition con4 = switchAppendEntry.empty() ? Conditions.notExists(switchAppendKey) : Conditions.revision(switchAppendKey).eq(switchAppendEntry.revision());
                CompoundCondition retryPreconditions = Conditions.and(con1, Conditions.and(con2, Conditions.and(con3, con4)));
                long catalogTimestamp = pendingAssignments.timestamp();
                Assignments newStableAssignments = Assignments.of(stableFromRaft, catalogTimestamp);
                Operation assignmentChainChangeOp = RebalanceRaftGroupEventsListener.handleAssignmentsChainChange(assignmentsChainKey, assignmentsChainEntry, pendingAssignments, newStableAssignments, configurationTerm, configurationIndex);
                byte[] stableFromRaftByteArray = newStableAssignments.toBytes();
                byte[] additionByteArray = AssignmentsQueue.toBytes(Assignments.of(calculatedPendingAddition, catalogTimestamp));
                byte[] reductionByteArray = AssignmentsQueue.toBytes(Assignments.of(calculatedPendingReduction, catalogTimestamp));
                byte[] switchReduceByteArray = Assignments.toBytes(calculatedSwitchReduce, catalogTimestamp);
                byte[] switchAppendByteArray = Assignments.toBytes(calculatedSwitchAppend, catalogTimestamp);
                if (!calculatedSwitchAppend.isEmpty()) {
                    successCase = Operations.ops(Operations.put(stablePartAssignmentsKey, stableFromRaftByteArray), Operations.put(pendingPartAssignmentsKey, additionByteArray), Operations.put(switchReduceKey, switchReduceByteArray), Operations.put(switchAppendKey, switchAppendByteArray), assignmentChainChangeOp).yield(1);
                    failCase = Operations.ops(new Operation[0]).yield(-1);
                } else if (!calculatedSwitchReduce.isEmpty()) {
                    successCase = Operations.ops(Operations.put(stablePartAssignmentsKey, stableFromRaftByteArray), Operations.put(pendingPartAssignmentsKey, reductionByteArray), Operations.put(switchReduceKey, switchReduceByteArray), Operations.put(switchAppendKey, switchAppendByteArray), assignmentChainChangeOp).yield(2);
                    failCase = Operations.ops(new Operation[0]).yield(-2);
                } else {
                    SimpleCondition con5;
                    if (plannedEntry.value() != null) {
                        con5 = Conditions.revision(plannedPartAssignmentsKey).eq(plannedEntry.revision());
                        AssignmentsQueue partAssignmentsPendingQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(newStableAssignments).target(Assignments.fromBytes(plannedEntry.value())).toQueue();
                        successCase = Operations.ops(Operations.put(stablePartAssignmentsKey, stableFromRaftByteArray), Operations.put(pendingPartAssignmentsKey, partAssignmentsPendingQueue.toBytes()), Operations.remove(plannedPartAssignmentsKey), assignmentChainChangeOp).yield(3);
                        failCase = Operations.ops(new Operation[0]).yield(-3);
                    } else {
                        con5 = Conditions.notExists(plannedPartAssignmentsKey);
                        successCase = Operations.ops(Operations.put(stablePartAssignmentsKey, stableFromRaftByteArray), Operations.remove(pendingPartAssignmentsKey), assignmentChainChangeOp).yield(4);
                        failCase = Operations.ops(new Operation[0]).yield(-4);
                    }
                    retryPreconditions = Conditions.and(retryPreconditions, con5);
                }
                Set<Assignment> finalCalculatedPendingAddition = calculatedPendingAddition;
                return this.metaStorageMgr.invoke(Statements.iif((Condition)retryPreconditions, successCase, failCase)).thenCompose(statementResult -> {
                    int res = statementResult.getAsInt();
                    if (res < 0) {
                        RebalanceRaftGroupEventsListener.logSwitchFailure(res, stableFromRaft, tablePartitionId);
                        return this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn);
                    }
                    RebalanceRaftGroupEventsListener.logSwitchSuccess(res, stableFromRaft, tablePartitionId, finalCalculatedPendingAddition, calculatedPendingReduction, plannedEntry);
                    return CompletableFutures.nullCompletedFuture();
                });
            });
        });
    }

    private static void logSwitchFailure(int res, Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId) {
        switch (res) {
            case -1: {
                LOG.info("Rebalance keys changed while trying to update rebalance pending addition information. Going to retry [tablePartitionID={}, appliedPeers={}]", tablePartitionId, stableFromRaft);
                break;
            }
            case -2: {
                LOG.info("Rebalance keys changed while trying to update rebalance pending reduce information. Going to retry [tablePartitionID={}, appliedPeers={}]", tablePartitionId, stableFromRaft);
                break;
            }
            case -4: 
            case -3: {
                LOG.info("Rebalance keys changed while trying to update rebalance information. Going to retry [tablePartitionId={}, appliedPeers={}]", tablePartitionId, stableFromRaft);
                break;
            }
            default: {
                assert (false) : res;
                break;
            }
        }
    }

    private static void logSwitchSuccess(int res, Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, Set<Assignment> calculatedPendingAddition, Set<Assignment> calculatedPendingReduction, Entry plannedEntry) {
        switch (res) {
            case 1: {
                LOG.info("Rebalance finished. Going to schedule next rebalance with addition [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", tablePartitionId, stableFromRaft, calculatedPendingAddition);
                break;
            }
            case 2: {
                LOG.info("Rebalance finished. Going to schedule next rebalance with reduction [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", tablePartitionId, stableFromRaft, calculatedPendingReduction);
                break;
            }
            case 3: {
                LOG.info("Rebalance finished. Going to schedule next rebalance [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", tablePartitionId, stableFromRaft, Assignments.fromBytes(plannedEntry.value()).nodes());
                break;
            }
            case 4: {
                LOG.info("Rebalance finished [tablePartitionId={}, appliedPeers={}]", tablePartitionId, stableFromRaft);
                break;
            }
            default: {
                assert (false) : res;
                break;
            }
        }
    }

    private static Operation handleAssignmentsChainChange(ByteArray assignmentsChainKey, Entry assignmentsChainEntry, Assignments pendingAssignments, Assignments stableAssignments, long configurationTerm, long configurationIndex) {
        if (assignmentsChainEntry.value() != null) {
            AssignmentsChain updatedAssignmentsChain = RebalanceRaftGroupEventsListener.updateAssignmentsChain(AssignmentsChain.fromBytes(assignmentsChainEntry.value()), stableAssignments, pendingAssignments, configurationTerm, configurationIndex);
            return Operations.put(assignmentsChainKey, updatedAssignmentsChain.toBytes());
        }
        return Operations.noop();
    }

    private static AssignmentsChain updateAssignmentsChain(AssignmentsChain assignmentsChain, Assignments newStable, Assignments pendingAssignments, long configurationTerm, long configurationIndex) {
        assert (assignmentsChain != null) : "Assignments chain cannot be null in HA mode.";
        assert (assignmentsChain.size() > 0) : "Assignments chain cannot be empty on stable switch.";
        if (!pendingAssignments.force() && !pendingAssignments.fromReset()) {
            return AssignmentsChain.of(configurationTerm, configurationIndex, newStable);
        }
        if (!pendingAssignments.force() && pendingAssignments.fromReset()) {
            assignmentsChain.replaceLast(newStable, configurationTerm, configurationIndex);
        } else {
            assignmentsChain.addLast(newStable, configurationTerm, configurationIndex);
        }
        return assignmentsChain;
    }

    private static Set<Assignment> createAssignments(PeersAndLearners configuration) {
        Stream<Assignment> newAssignments = Stream.concat(configuration.peers().stream().map(peer -> Assignment.forPeer(peer.consistentId())), configuration.learners().stream().map(peer -> Assignment.forLearner(peer.consistentId())));
        return newAssignments.collect(Collectors.toSet());
    }

    private static Assignments readAssignments(Entry entry) {
        byte[] value = entry.value();
        return value == null ? Assignments.EMPTY : Assignments.fromBytes(value);
    }
}

