/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.tempstorage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitWriteException;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorageImpl;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorageProvider;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;

public class TempStorageProviderImpl
implements TempStorageProvider {
    private static final IgniteLogger LOG = Loggers.forClass(TempStorageProviderImpl.class);
    private final Executor executor;
    private Path storageDir;

    public TempStorageProviderImpl(Executor executor) {
        this.executor = executor;
    }

    public void init(Path storageDir) {
        this.storageDir = storageDir;
    }

    @Override
    public TempStorage tempStorage(String id, Version version) {
        try {
            Path storageDir = this.storageDir.resolve(id).resolve(version.render());
            Files.createDirectories(storageDir, new FileAttribute[0]);
            return new TempStorageImpl(storageDir, this.executor);
        }
        catch (IOException ex) {
            LOG.error("Failed to create temp storage {} with id {} and version {}", ex, this.storageDir, id, version);
            throw new DeploymentUnitWriteException("Failed to create deployemnt unit temp storage.", ex);
        }
    }
}

