/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft.commands;

import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class JoinReadyCommandDeserializer
implements MessageDeserializer<JoinReadyCommand> {
    private final JoinReadyCommandBuilder msg;

    JoinReadyCommandDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.joinReadyCommand();
    }

    @Override
    public Class<JoinReadyCommand> klass() {
        return JoinReadyCommand.class;
    }

    @Override
    public JoinReadyCommand getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ClusterNodeMessage tmp = (ClusterNodeMessage)reader.readMessage("node");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.node(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JoinReadyCommand.class);
    }
}

