/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.rest;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.apache.ignite3.internal.cli.config.CliConfigKeys;
import org.apache.ignite3.internal.cli.config.ConfigManager;
import org.apache.ignite3.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientSettings;
import org.apache.ignite3.internal.cli.core.rest.ApiClientSettingsBuilder;
import org.apache.ignite3.internal.cli.core.rest.BasicAuthenticationInterceptor;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ApiClientFactory {
    private static final Pattern INCORRECT_PASSWORD_PATTERN = Pattern.compile(".*keystore password was incorrect.*");
    private final Map<ApiClientSettings, ApiClient> clientMap = new ConcurrentHashMap<ApiClientSettings, ApiClient>();
    private final AtomicReference<ApiClientSettings> currentSessionSettings = new AtomicReference();
    private final ConfigManagerProvider configManagerProvider;

    public ApiClientFactory(ConfigManagerProvider configManagerProvider) {
        this.configManagerProvider = configManagerProvider;
    }

    public ApiClient getClient(String path) {
        return this.getClientFromSettings(this.settingsWithAuth(path));
    }

    @PreDestroy
    private void clearLoggers() {
        CliLoggers.clearLoggers();
    }

    private ApiClient getClientFromSettings(ApiClientSettings settings) {
        ApiClient apiClient = this.clientMap.computeIfAbsent(settings, ApiClientFactory::buildClient);
        CliLoggers.addApiClient(apiClient);
        return apiClient;
    }

    private ApiClientSettings settingsWithAuth(String path) {
        ConfigManager configManager = this.configManagerProvider.get();
        ApiClientSettingsBuilder builder = ApiClientSettings.builder().basePath(path).keyStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PATH.value())).keyStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PASSWORD.value())).trustStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PATH.value())).trustStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PASSWORD.value())).ciphers(configManager.getCurrentProperty(CliConfigKeys.REST_CIPHERS.value()));
        return this.setupAuthentication(builder).build();
    }

    private ApiClientSettingsBuilder setupAuthentication(ApiClientSettingsBuilder builder) {
        ConfigManager configManager = this.configManagerProvider.get();
        ApiClientSettings currentCredentialsSettings = this.currentSessionSettings();
        String username = currentCredentialsSettings != null ? currentCredentialsSettings.basicAuthenticationUsername() : configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value());
        String password = currentCredentialsSettings != null ? currentCredentialsSettings.basicAuthenticationPassword() : configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value());
        builder.basicAuthenticationUsername(username).basicAuthenticationPassword(password);
        return builder;
    }

    public static ApiClient buildClient(ApiClientSettings settings) {
        try {
            Interceptor authInterceptor;
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.retryOnConnectionFailure(false);
            if (!StringUtils.nullOrBlank(settings.trustStorePath()) || !StringUtils.nullOrBlank(settings.trustStorePassword())) {
                ApiClientFactory.applySslSettings(builder, settings);
            }
            if ((authInterceptor = ApiClientFactory.authInterceptor(settings)) != null) {
                builder.addInterceptor(authInterceptor);
            }
            OkHttpClient okHttpClient = builder.build();
            return new ApiClient(okHttpClient).setBasePath(settings.basePath());
        }
        catch (Exception e) {
            throw new IgniteCliApiException(e, settings.basePath());
        }
    }

    public void setSessionSettings(@Nullable ApiClientSettings settings) {
        if (settings != null) {
            this.currentSessionSettings.compareAndSet(null, settings);
        } else {
            this.currentSessionSettings.set(null);
        }
    }

    public ApiClientSettings currentSessionSettings() {
        return this.currentSessionSettings.get();
    }

    private static OkHttpClient.Builder applySslSettings(OkHttpClient.Builder builder, ApiClientSettings settings) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        TrustManagerFactory trustManagerFactory = ApiClientFactory.trustManagerFactory(settings);
        KeyManagerFactory keyManagerFactory = ApiClientFactory.keyManagerFactory(settings);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        ApiClientFactory.setCiphers(builder, settings);
        return builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
    }

    private static KeyManagerFactory keyManagerFactory(ApiClientSettings settings) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (StringUtils.nullOrBlank(settings.keyStorePath())) {
                keyManagerFactory.init(null, null);
            } else {
                char[] password = settings.keyStorePassword() == null ? null : settings.keyStorePassword().toCharArray();
                KeyStore keyStore = KeyStore.getInstance(new File(settings.keyStorePath()), password);
                keyManagerFactory.init(keyStore, password);
            }
            return keyManagerFactory;
        }
        catch (IOException e) {
            if (INCORRECT_PASSWORD_PATTERN.matcher(e.getMessage()).matches()) {
                throw new IOException("Key-store password was incorrect", e.getCause());
            }
            throw e;
        }
    }

    private static TrustManagerFactory trustManagerFactory(ApiClientSettings settings) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (StringUtils.nullOrBlank(settings.trustStorePath())) {
                trustManagerFactory.init((KeyStore)null);
            } else {
                char[] password = settings.trustStorePassword() == null ? null : settings.trustStorePassword().toCharArray();
                KeyStore trustStore = KeyStore.getInstance(new File(settings.trustStorePath()), password);
                trustManagerFactory.init(trustStore);
            }
            return trustManagerFactory;
        }
        catch (IOException e) {
            if (INCORRECT_PASSWORD_PATTERN.matcher(e.getMessage()).matches()) {
                throw new IOException("Trust-store password was incorrect", e.getCause());
            }
            throw e;
        }
    }

    private static void setCiphers(OkHttpClient.Builder builder, ApiClientSettings settings) {
        if (!StringUtils.nullOrBlank(settings.ciphers())) {
            List cipherSuites = Arrays.stream(settings.ciphers().split(",")).map(String::strip).collect(Collectors.toList());
            ConnectionSpec spec = new ConnectionSpec.Builder(true).cipherSuites((String[])cipherSuites.toArray(String[]::new)).build();
            builder.connectionSpecs(List.of(spec));
        }
    }

    @Nullable
    private static Interceptor authInterceptor(ApiClientSettings settings) {
        if (!StringUtils.nullOrBlank(settings.basicAuthenticationUsername()) && !StringUtils.nullOrBlank(settings.basicAuthenticationPassword())) {
            return new BasicAuthenticationInterceptor(settings.basicAuthenticationUsername(), settings.basicAuthenticationPassword());
        }
        return null;
    }
}

