/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.commands.TopLevelCliReplCommand;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.StringCallInput;
import org.apache.ignite3.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import org.apache.ignite3.internal.cli.core.repl.EventListeningActivationPoint;
import org.apache.ignite3.internal.cli.core.repl.Repl;
import org.apache.ignite3.internal.cli.core.repl.SessionDefaultValueProvider;
import org.apache.ignite3.internal.cli.core.repl.executor.ReplExecutorProvider;
import org.apache.ignite3.internal.cli.core.repl.prompt.PromptProvider;

@Singleton
public class ReplManager {
    @Inject
    private ReplExecutorProvider replExecutorProvider;
    @Inject
    private PromptProvider promptProvider;
    @Inject
    private SessionDefaultValueProvider defaultValueProvider;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private EventListeningActivationPoint eventListeningActivationPoint;

    public void subscribe() {
        this.eventListeningActivationPoint.subscribe();
    }

    public void startReplMode() {
        this.replExecutorProvider.get().execute(Repl.builder().withPromptProvider(this.promptProvider).withCommandClass(TopLevelCliReplCommand.class).withDefaultValueProvider(this.defaultValueProvider).withCallExecutionPipelineProvider((executor, exceptionHandlers, line) -> CallExecutionPipeline.builder(executor).inputProvider(() -> new StringCallInput(line)).output(System.out).errOutput(System.err).exceptionHandlers(new DefaultExceptionHandlers()).exceptionHandlers(exceptionHandlers).build()).withOnStart(this.question::askQuestionOnReplStart).withHistoryFileName("history").withAutosuggestionsWidgets().build());
    }
}

