/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.ignite3.internal.lang.Debuggable;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.rest.api.node.State;
import org.apache.ignite3.internal.rest.node.StateProvider;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.TestOnly;

class LifecycleManager
implements StateProvider,
Debuggable {
    private static final IgniteLogger LOG = Loggers.forClass(LifecycleManager.class);
    private final String nodeName;
    private final AtomicReference<State> status = new AtomicReference<State>(State.STARTING);
    private final List<IgniteComponent> startedComponents = new ArrayList<IgniteComponent>();
    private final List<CompletableFuture<Void>> allComponentsStartFutures = new ArrayList<CompletableFuture<Void>>();
    private final CompletableFuture<Void> stopFuture = new CompletableFuture();

    LifecycleManager(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public State getState() {
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> startComponentAsync(IgniteComponent component, ComponentContext componentContext) throws NodeStoppingException {
        if (this.status.get() == State.STOPPING) {
            throw new NodeStoppingException("Node=[" + this.nodeName + "] was stopped");
        }
        LifecycleManager lifecycleManager = this;
        synchronized (lifecycleManager) {
            this.startedComponents.add(component);
            CompletableFuture<Void> future = component.startAsync(componentContext);
            this.allComponentsStartFutures.add(future);
            return future;
        }
    }

    CompletableFuture<Void> startComponentsAsync(ComponentContext componentContext, IgniteComponent ... components) throws NodeStoppingException {
        CompletableFuture[] futures = new CompletableFuture[components.length];
        for (int i = 0; i < components.length; ++i) {
            futures[i] = this.startComponentAsync(components[i], componentContext);
        }
        return CompletableFuture.allOf(futures);
    }

    void onStartComplete() throws NodeStoppingException {
        LOG.info("Start complete", new Object[0]);
        State currentStatus = this.status.compareAndExchange(State.STARTING, State.STARTED);
        if (currentStatus == State.STOPPING) {
            throw new NodeStoppingException();
        }
        if (currentStatus != State.STARTING) {
            throw new IllegalStateException("Unexpected node status: " + currentStatus);
        }
    }

    synchronized CompletableFuture<Void> allComponentsStartFuture(Executor startExecutor) {
        return CompletableFuture.allOf((CompletableFuture[])this.allComponentsStartFutures.toArray(CompletableFuture[]::new)).whenCompleteAsync((v, e) -> {
            LifecycleManager lifecycleManager = this;
            synchronized (lifecycleManager) {
                this.allComponentsStartFutures.clear();
            }
        }, startExecutor);
    }

    CompletableFuture<Void> stopNode(ComponentContext componentContext) {
        State currentStatus = this.status.getAndSet(State.STOPPING);
        if (currentStatus != State.STOPPING) {
            this.initiateAllComponentsStop(componentContext);
        }
        return this.stopFuture;
    }

    private synchronized void initiateAllComponentsStop(ComponentContext componentContext) {
        ArrayList<IgniteComponent> components = new ArrayList<IgniteComponent>(this.startedComponents);
        Collections.reverse(components);
        for (IgniteComponent component : components) {
            try {
                component.beforeNodeStop();
            }
            catch (Exception e) {
                LOG.warn("Unable to execute before node stop [component={}, nodeName={}]", e, component, this.nodeName);
            }
        }
        IgniteUtils.stopAsync(componentContext, components).whenComplete((BiConsumer)CompletableFutures.copyStateTo(this.stopFuture));
    }

    @Override
    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        Debuggable.dumpState(writer, indent, this.startedComponents);
    }
}

