/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnPartitionDataView;
import org.apache.ignite.internal.util.typedef.F;

public class ColumnPartitionDataViewSupplier {
    private final IgniteStatisticsStore store;

    public ColumnPartitionDataViewSupplier(IgniteStatisticsStore store) {
        this.store = store;
    }

    public Iterable<StatisticsColumnPartitionDataView> columnPartitionStatisticsViewSupplier(Map<String, Object> filter) {
        Map<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> partsStatsMap;
        String type = (String)filter.get("type");
        if (type != null && !"TABLE".equalsIgnoreCase(type)) {
            return Collections.emptyList();
        }
        String schema = (String)filter.get("schema");
        String name = (String)filter.get("name");
        Integer partId = (Integer)filter.get("partition");
        String column = (String)filter.get("column");
        if (!F.isEmpty(schema) && !F.isEmpty(name)) {
            ObjectPartitionStatisticsImpl partStat;
            StatisticsKey key = new StatisticsKey(schema, name);
            Collection<Object> keyStat = partId == null ? this.store.getLocalPartitionsStatistics(key) : ((partStat = this.store.getLocalPartitionStatistics(key, partId)) == null ? Collections.emptyList() : Collections.singletonList(partStat));
            partsStatsMap = Collections.singletonMap(key, keyStat);
        } else {
            partsStatsMap = this.store.getAllLocalPartitionsStatistics(schema);
        }
        ArrayList<StatisticsColumnPartitionDataView> res = new ArrayList<StatisticsColumnPartitionDataView>();
        for (Map.Entry<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> partsStatsEntry : partsStatsMap.entrySet()) {
            StatisticsKey key = partsStatsEntry.getKey();
            for (ObjectPartitionStatisticsImpl partStat : partsStatsEntry.getValue()) {
                if (column == null) {
                    for (Map.Entry<String, ColumnStatistics> colStatEntry : partStat.columnsStatistics().entrySet()) {
                        res.add(new StatisticsColumnPartitionDataView(key, colStatEntry.getKey(), partStat));
                    }
                    continue;
                }
                ColumnStatistics colStat = partStat.columnStatistics(column);
                if (colStat == null) continue;
                res.add(new StatisticsColumnPartitionDataView(key, column, partStat));
            }
        }
        return res;
    }
}

