/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.running;

import java.util.UUID;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.running.QueryRunningFuture;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridRunningQueryInfo {
    private final long id;
    private final UUID nodeId;
    private final String qry;
    private final GridCacheQueryType qryType;
    private final String schemaName;
    private final long startTime;
    private final long startTimeNanos;
    private final GridQueryCancel cancel;
    private final boolean loc;
    @GridToStringExclude
    private final QueryRunningFuture fut = new QueryRunningFuture();
    private final Span span;
    private final String qryInitiatorId;
    private final boolean enforceJoinOrder;
    private final boolean lazy;
    private final boolean distributedJoins;
    private final UUID subjId;

    public GridRunningQueryInfo(long id, UUID nodeId, String qry, GridCacheQueryType qryType, String schemaName, long startTime, long startTimeNanos, GridQueryCancel cancel, boolean loc, String qryInitiatorId, boolean enforceJoinOrder, boolean lazy, boolean distributedJoins, UUID subjId) {
        this.id = id;
        this.nodeId = nodeId;
        this.qry = qry;
        this.qryType = qryType;
        this.schemaName = schemaName;
        this.startTime = startTime;
        this.startTimeNanos = startTimeNanos;
        this.cancel = cancel;
        this.loc = loc;
        this.span = MTC.span();
        this.qryInitiatorId = qryInitiatorId;
        this.enforceJoinOrder = enforceJoinOrder;
        this.lazy = lazy;
        this.distributedJoins = distributedJoins;
        this.subjId = subjId;
    }

    public long id() {
        return this.id;
    }

    public String globalQueryId() {
        return QueryUtils.globalQueryId(this.nodeId, this.id);
    }

    public String query() {
        return this.qry;
    }

    public GridCacheQueryType queryType() {
        return this.qryType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public long startTime() {
        return this.startTime;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public void cancel() {
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    public QueryRunningFuture runningFuture() {
        return this.fut;
    }

    public boolean cancelable() {
        return this.cancel != null;
    }

    public boolean local() {
        return this.loc;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public Span span() {
        return this.span;
    }

    public String queryInitiatorId() {
        return this.qryInitiatorId;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean enforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public String toString() {
        return S.toString(GridRunningQueryInfo.class, this);
    }
}

