/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.util.typedef.F;

public class QueryBinaryProperty
implements GridQueryProperty {
    private final GridKernalContext ctx;
    private String propName;
    private String alias;
    private QueryBinaryProperty parent;
    private Class<?> type;
    private final boolean isKeyProp;
    private volatile BinaryField field;
    private volatile boolean fieldTaken;
    private final boolean notNull;
    private final Object defaultValue;
    private final int precision;
    private final int scale;

    public QueryBinaryProperty(GridKernalContext ctx, String propName, QueryBinaryProperty parent, Class<?> type, boolean key, String alias, boolean notNull, Object defaultValue, int precision, int scale) {
        this.ctx = ctx;
        this.propName = propName;
        this.alias = F.isEmpty(alias) ? propName : alias;
        this.parent = parent;
        this.type = type;
        this.notNull = notNull;
        this.isKeyProp = key;
        this.defaultValue = defaultValue;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public Object value(Object key, Object val) throws IgniteCheckedException {
        Object obj;
        if (this.parent != null) {
            obj = this.parent.value(key, val);
            if (obj == null) {
                return null;
            }
            if (!this.ctx.cacheObjects().isBinaryObject(obj)) {
                throw new IgniteCheckedException("Non-binary object received as a result of property extraction [parent=" + this.parent + ", propName=" + this.propName + ", obj=" + obj + "]");
            }
        } else {
            Object object = obj = this.isKeyProp ? key : val;
        }
        if (obj instanceof BinaryObject) {
            BinaryObject obj0 = (BinaryObject)obj;
            return this.fieldValue(obj0);
        }
        if (obj instanceof BinaryObjectBuilder) {
            BinaryObjectBuilder obj0 = (BinaryObjectBuilder)obj;
            return obj0.getField(this.propName);
        }
        if (obj instanceof KeyCacheObjectImpl) {
            KeyCacheObjectImpl obj0 = (KeyCacheObjectImpl)obj;
            return obj0.value(null, false);
        }
        throw new IgniteCheckedException("Unexpected binary object class [type=" + obj.getClass() + "]");
    }

    @Override
    public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
        Object obj;
        Object object = obj = this.key() ? key : val;
        if (obj == null) {
            return;
        }
        Object srcObj = obj;
        if (!(srcObj instanceof BinaryObjectBuilder)) {
            throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
        }
        if (this.parent != null) {
            obj = this.parent.value(key, val);
        }
        boolean needsBuild = false;
        if (obj instanceof BinaryObjectExImpl) {
            if (this.parent == null) {
                throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
            }
            needsBuild = true;
            obj = ((BinaryObjectExImpl)obj).toBuilder();
        }
        if (!(obj instanceof BinaryObjectBuilder)) {
            throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
        }
        this.setValue0((BinaryObjectBuilder)obj, this.propName, propVal, this.type());
        if (needsBuild) {
            obj = ((BinaryObjectBuilder)obj).build();
            assert (this.parent != null);
            this.setValue0((BinaryObjectBuilder)srcObj, this.parent.propName, obj, obj.getClass());
        }
    }

    private <T> void setValue0(BinaryObjectBuilder builder, String field, Object val, Class<T> valType) {
        builder.setField(field, val, valType);
    }

    private BinaryField binaryField(BinaryObject obj) {
        if (this.ctx.query().skipFieldLookup()) {
            return null;
        }
        BinaryField field0 = this.field;
        if (field0 == null && !this.fieldTaken) {
            BinaryType type;
            BinaryType binaryType = type = obj instanceof BinaryObjectEx ? ((BinaryObjectEx)obj).rawType() : obj.type();
            if (type != null) {
                field0 = type.field(this.propName);
                assert (field0 != null);
                this.field = field0;
            }
            this.fieldTaken = true;
        }
        return field0;
    }

    private Object fieldValue(BinaryObject obj) {
        BinaryField field = this.binaryField(obj);
        if (field != null) {
            return field.value(obj);
        }
        return obj.field(this.propName);
    }

    @Override
    public String name() {
        return this.alias;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public boolean key() {
        return this.isKeyProp;
    }

    @Override
    public GridQueryProperty parent() {
        return this.parent;
    }

    @Override
    public boolean notNull() {
        return this.notNull;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }
}

